package com.artfess.manage.duty.dao;



import com.artfess.manage.duty.model.CmgtDutyWorkarrange;
import com.artfess.manage.duty.vo.WorkArrangeInfoVo;
import com.artfess.manage.duty.vo.WorkArrangeMemberVo;
import com.artfess.manage.duty.vo.WorkarrangeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 排班信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-28
 */
public interface CmgtDutyWorkarrangeDao extends BaseMapper<CmgtDutyWorkarrange> {

    IPage<CmgtDutyWorkarrange> queryPage(IPage<CmgtDutyWorkarrange> convert2IPage, @Param(Constants.WRAPPER) Wrapper<CmgtDutyWorkarrange> convert2Wrapper);

    /**
     *
     * @param params
     * @return
     */
    List<WorkarrangeVo> findArrangeInfoByDay(Map<String,Object> params);

    /**
     *
     * @param params
     * @return
     */
    List<WorkArrangeMemberVo> findMemberArrange(Map<String,Object> params);

    /**
     * 查询当月所有排班信息
     * @param params
     * @return
     */
    List<WorkArrangeInfoVo> findAllByMonth(Map<String,Object> params);
}
