package com.artfess.manage.duty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.manager.CmgtDutyTeamMemberManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 勤务队员信息
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
@Slf4j
@Api(tags = "勤务队员信息-勤务管理")
@RestController
@RequestMapping("/manager/duty/member")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtDutyTeamMemberController extends BaseController<CmgtDutyTeamMemberManager, CmgtDutyTeamMember> {

    @Autowired
    private CmgtDutyTeamManager cmgtDutyTeamManager;

    @Autowired
    private CmgtDutyTeamMemberManager cmgtDutyTeamMemberManager;


    @PostMapping(value = "/query/team", produces = {"application/json; charset=utf-8"})
    @ApiOperation("查询所有小组信息")
    public CommonResult<String> query() {
        //List list = cmgtDutyTeamManager.findAllTeam();
        List list = cmgtDutyTeamManager.findOrgTeamTreeData();
        return CommonResult.success(list, null);
    }

    @PostMapping(value = "/pageQuery", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询")
    public PageList<CmgtDutyTeamMemberDto> pageQuery(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<CmgtDutyTeamMember> queryFilter) {
        return cmgtDutyTeamMemberManager.pageQuery(queryFilter);
    }

    @PostMapping("/create")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtDutyTeamMemberDto t) {
        if (StringUtil.isEmpty(t.getCode())) {
            t.setCode(PinyinUtil.getPinyinToLowerCase(t.getName()));
        }
        String result = cmgtDutyTeamMemberManager.create(t);
        if (result == null) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "创建实体失败");
        }
        return new CommonResult<>(result);
    }


    @PutMapping("/update")
    @ApiOperation("更新实体的接口")
    public CommonResult<String> update(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtDutyTeamMemberDto t) {
        if (StringUtil.isEmpty(t.getCode())) {
            t.setCode(PinyinUtil.getPinyinToLowerCase(t.getName()));
        }
        String result = cmgtDutyTeamMemberManager.update(t);
        if (result == null) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>(result);
    }


//    @DeleteMapping("/delete/")
//    @ApiOperation("根据id集合批量删除")
//    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
//        boolean result = cmgtDutyTeamMemberManager.delete(Arrays.asList(ids));
//        if (!result) {
//            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
//        }
//        return new CommonResult<>();
//    }

}
