package com.artfess.manage.base.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.manager.dto.CmgtBasePositionDto;
import com.artfess.manage.base.model.CmgtBasePosition;

import java.util.List;

/**
 * 基础位置信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-09-24
 */
public interface CmgtBasePositionManager extends BaseManager<CmgtBasePosition> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<CmgtBasePositionDto> pageQuery(QueryFilter<CmgtBasePosition> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(CmgtBasePosition t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(CmgtBasePosition t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(CmgtBasePosition t);


    String create(CmgtBasePositionDto dto);

    String update(CmgtBasePositionDto dto);

    boolean delete(List<String> ids);



}
