package com.artfess.manage.base;


import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资分类 前端控制器
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @email wujl
 * @since 2022-07-21
 */
@Slf4j
@RestController
@RequestMapping("/manager/common/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class ManageCommonController {


    @Resource
    private ManageCommonService manageCommonService;


    @GetMapping(value = "/select/options", produces = {"application/json; charset=utf-8"})
    @ApiOperation("获取选择选项集合")
    public List<Object> findSelectOptions(String name, String query) {
        return manageCommonService.findSelectOptions(name, query);
    }


    @GetMapping(value = "/select/duty/months", produces = {"application/json; charset=utf-8"})
    @ApiOperation("获取勤务月份选项")
    public JSONArray getDutyMonths() {
        JSONArray r = JSONUtil.createArray();
        Date now = new Date();
        int xh = 0;
        for (int i = -6; i < 2; i++) {
            Date newDate = DateUtil.offset(now, DateField.MONTH, i);
            r.add(JSONUtil.createObj().putOpt("value", xh).
                    putOpt("text", DateUtil.format(newDate, "yyyy年MM月"))
                    .putOpt("wd", DateUtil.format(DateUtil.beginOfMonth(newDate), "yyyy-MM"))
                    .putOpt("min", DateUtil.format(DateUtil.beginOfMonth(newDate), "yyyy-MM-dd"))
                    .putOpt("max", DateUtil.format(DateUtil.endOfMonth(newDate), "yyyy-MM-dd"))
            );
            xh++;
        }
        return r;
    }

    @GetMapping(value = "/select/duty/days", produces = {"application/json; charset=utf-8"})
    @ApiOperation("获取勤务月所有日期选项")
    public JSONArray getDutyDays(String cdate) {
        JSONArray r = JSONUtil.createArray();

        Date beginDate = DateUtil.beginOfMonth(DateUtil.parseDate(cdate));

        Date endDate = DateUtil.endOfMonth(DateUtil.parseDate(cdate));

        int xh = 0;
        for (int i = 0; i < 31; i++) {
            Date newDate = DateUtil.offset(beginDate, DateField.DAY_OF_MONTH, i);
            r.add(JSONUtil.createObj().putOpt("value", xh).
                    putOpt("text", DateUtil.format(newDate, "yyyy-MM-dd"))
                    .putOpt("week", DateUtil.dayOfWeekEnum(newDate).toChinese())
                    .putOpt("week", DateUtil.dayOfWeekEnum(newDate).toChinese())
                    .putOpt("min", DateUtil.format(DateUtil.beginOfMonth(newDate), "yyyy-MM-dd"))
                    .putOpt("max", DateUtil.format(DateUtil.endOfMonth(newDate), "yyyy-MM-dd"))
            );
            if (newDate.equals(endDate)) {
                break;
            }
            xh++;
        }
        return r;
    }

    @GetMapping(value = "/select/org/zgj", produces = {"application/json; charset=utf-8"})
    @ApiOperation("获综管局组织")
    public List<JSONObject> getZgjOrgs() {
        return manageCommonService.findZGJOrg().stream().map(o -> {
            return JSONUtil.createObj().putOpt("text", o.getName()).putOpt("value", o.getId());
        }).collect(Collectors.toList());
    }

//
//    @RequestMapping(value = "fileUpload", method = RequestMethod.POST, produces = { "application/json; charset=utf-8" })
//    @ApiOperation(value = "上传操作", httpMethod = "POST", notes = "上传操作")
//    public UploadResult fileUpload(@ApiParam(name = "params", value = "格式限定") @RequestParam Map<String, Object> params,
//                                   @ApiParam(name = "files", value = "上传的文件流") @RequestBody List<MultipartFile> files) throws Exception {
//
//    }


    @PostMapping(value = "/upload/excel")
    @ApiOperation("上传文件")
    public ResponseEntity<Object> upload(@RequestParam("file") MultipartFile file) throws IOException {

        ExcelReader reader = ExcelUtil.getReader(file.getInputStream(), 0);
        //reader.setHeaderAlias()
        List<Map<String, Object>> rowsList = reader.readAll();

        System.out.println("==========rowsList=========" + rowsList);
        Map<String, Object> ro = new HashMap<String, Object>();
        ro.put("realName", file.getName());
        //ro.put("type", type);
        //ro.put("msg", rmsg);
        return new ResponseEntity<>(ro, HttpStatus.OK);
    }


}
