package com.artfess.manage.safty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * cmgt_safty_danger_checkplan
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Data
@ApiModel(value = "CmgtSaftyDangerCheckplan对象", description = "安全隐患排查计划")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyDangerCheckplan extends AutoFillModel<CmgtSaftyDangerCheckplan> {

    /**
     * 主键_ID
     */
    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 隐患类型
     */
    @ApiModelProperty(value = "隐患类型")
    @TableField("danger_type_")
    @NotBlank(message = "隐患类型", groups = {AddGroup.class, UpdateGroup.class})
    private String dangerType;

    /**
     * 排查时间
     */
    @ApiModelProperty(value = "排查时间")
    @TableField("check_date_")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate checkDate;

    /**
     * 检查人
     */
    @ApiModelProperty(value = "检查人")
    @TableField("check_user_")
    private String checkUser;

    /**
     * 检查内容
     */
    @ApiModelProperty(value = "检查内容")
    @TableField("content_")
    private String content;

    /**
     * 检查对象
     */
    @ApiModelProperty(value = "检查对象")
    @TableField("recipient_")
    private String recipient;

    /**
     * 排查方案
     */
    @ApiModelProperty(value = "排查方案")
    @TableField("pcfa_")
    private String pcfa;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /**
     * 删除标识，1已删除，0未删除
     */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;


    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    /**
     * 数据时间戳
     */
    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;


}
