package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingProjectDao;
import com.artfess.manage.safty.manager.CmgtSaftyTrainingProjectManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyTrainingProjectDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyTrainingProjectDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyTrainingProject;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 培训项目 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyTrainingProjectManagerImpl extends BaseManagerImpl<CmgtSaftyTrainingProjectDao, CmgtSaftyTrainingProject> implements CmgtSaftyTrainingProjectManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtSaftyTrainingProjectDao cmgtSaftyTrainingProjectDao;

    @Resource
    private CmgtSaftyTrainingProjectDtoMapper cmgtSaftyTrainingProjectDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtSaftyTrainingProjectDto> pageQuery(QueryFilter<CmgtSaftyTrainingProject> queryFilter) {
        PageList<CmgtSaftyTrainingProject> result = query(queryFilter);
        PageList<CmgtSaftyTrainingProjectDto> r = new PageList<CmgtSaftyTrainingProjectDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyTrainingProjectDto t = cmgtSaftyTrainingProjectDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyTrainingProject t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyTrainingProject t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyTrainingProject t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtSaftyTrainingProjectDto dto) {
        CmgtSaftyTrainingProject t = cmgtSaftyTrainingProjectDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtSaftyTrainingProjectDto dto) {
        CmgtSaftyTrainingProject t = cmgtSaftyTrainingProjectDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
