package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingPlanDao;
import com.artfess.manage.safty.manager.CmgtSaftyTrainingPlanManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyTrainingPlanDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyTrainingPlanDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyTrainingPlan;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 安全培训计划 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyTrainingPlanManagerImpl extends BaseManagerImpl<CmgtSaftyTrainingPlanDao, CmgtSaftyTrainingPlan> implements CmgtSaftyTrainingPlanManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtSaftyTrainingPlanDao cmgtSaftyTrainingPlanDao;

    @Resource
    private CmgtSaftyTrainingPlanDtoMapper cmgtSaftyTrainingPlanDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtSaftyTrainingPlanDto> pageQuery(QueryFilter<CmgtSaftyTrainingPlan> queryFilter) {
        PageList<CmgtSaftyTrainingPlan> result = query(queryFilter);
        PageList<CmgtSaftyTrainingPlanDto> r = new PageList<CmgtSaftyTrainingPlanDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyTrainingPlanDto t = cmgtSaftyTrainingPlanDtoMapper.toDto(e);
                                    t.setTrainingProjectIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtSaftyTrainingProjects","id","name",t.getTrainingProjectId()));


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyTrainingPlan t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyTrainingPlan t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyTrainingPlan t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtSaftyTrainingPlanDto dto) {
        CmgtSaftyTrainingPlan t = cmgtSaftyTrainingPlanDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtSaftyTrainingPlanDto dto) {
        CmgtSaftyTrainingPlan t = cmgtSaftyTrainingPlanDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
