package com.artfess.manage.safty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.manage.safty.manager.CmgtSaftyPlanTaskManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyPlanTaskDto;
import com.artfess.manage.safty.model.CmgtSaftyPlanTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;

/**
 * 安全计划任务 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Slf4j
@Api(tags = "安全计划任务")
@RestController
@RequestMapping("/manager/cmgtSaftyPlanTask")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtSaftyPlanTaskController extends BaseController<CmgtSaftyPlanTaskManager, CmgtSaftyPlanTask> {

    @Autowired
    private CmgtSaftyPlanTaskManager cmgtSaftyPlanTaskManager;


    @PostMapping(value="/pageQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询")
    public PageList<CmgtSaftyPlanTaskDto> pageQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CmgtSaftyPlanTask> queryFilter) {
        return cmgtSaftyPlanTaskManager.pageQuery(queryFilter);
    }



    @PostMapping("/create")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtSaftyPlanTaskDto t) {
        String result =  cmgtSaftyPlanTaskManager.create(t);
        if (result == null) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "创建实体失败");
        }
        return new CommonResult<>(result);
    }


    @PutMapping("/update")
    @ApiOperation("更新实体的接口")
    public CommonResult<String> update(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtSaftyPlanTaskDto t) {

        String result =  cmgtSaftyPlanTaskManager.update(t);
        if (result == null) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>(result);
    }


    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result =  cmgtSaftyPlanTaskManager.delete(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }



}
