package com.artfess.manage.material.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.material.dao.CmgtMaterialClassDao;
import com.artfess.manage.material.manager.CmgtMaterialClassManager;
import com.artfess.manage.material.model.CmgtMaterialClass;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资分类 服务实现类
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @email wujl
 * @since 2022-07-21
 */
@Service
public class CmgtMaterialClassManagerImpl extends BaseManagerImpl<CmgtMaterialClassDao, CmgtMaterialClass> implements CmgtMaterialClassManager {

    @Resource
    CmgtMaterialClassDao cmgtMaterialClassDao;

    @Override
    public List<CmgtMaterialClass> findAllClass() {
        return this.baseMapper.selectList(null);
    }

    public List<CmgtMaterialClass> findByParentId(String parentId) {
        QueryWrapper<CmgtMaterialClass> queryWrapper = new QueryWrapper();
        if (StringUtil.isEmpty(parentId)) {
            queryWrapper.isNull("PARENT_ID_");
        } else {
            queryWrapper.eq("PARENT_ID_", parentId);
        }
        return cmgtMaterialClassDao.selectList(queryWrapper);
    }


    /**
     * 查询本级及子级分类ID
     *
     * @param parentId
     * @return
     */
    public String[] findAllChildIds(String parentId) {
        List<String> l = findAllByParentId(parentId).stream().map(c -> c.getId()).collect(Collectors.toList());
        l.add(0, parentId);
        return l.toArray(new String[]{});
    }

    private List<CmgtMaterialClass> findAllByParentId(String parentId) {
        List<CmgtMaterialClass> r = this.findByParentId(parentId);
        if (r.size() > 0) {
            r.forEach(c -> {
                List<CmgtMaterialClass> cr = this.findAllByParentId(c.getId());
                if (cr.size() > 0) {
                    r.addAll(cr);
                }
            });
        }
        return r;
    }
}
