package com.artfess.manage.dwd.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;


/**
 * dwd_sj_weather_forcast_mi
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-21
 */
@Data
@ApiModel(value="DwdSjWeatherForcastMi对象", description="来自互联网心知天气的天气预报")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdSjWeatherForcastMi extends BaseModel<DwdSjWeatherForcastMi> {


    /** 日期 */
    @ApiModelProperty(value = "日期")
    @TableField("date")
    private String date;

    /** 白天天气现象文字 */
    @ApiModelProperty(value = "白天天气现象文字")
    @TableField("text_day")
    private String textDay;

    /** 白天天气现象代码 */
    @ApiModelProperty(value = "白天天气现象代码")
    @TableField("code_day")
    private String codeDay;

    /** 晚间天气现象文字 */
    @ApiModelProperty(value = "晚间天气现象文字")
    @TableField("text_night")
    private String textNight;

    /** 晚间天气现象代码 */
    @ApiModelProperty(value = "晚间天气现象代码")
    @TableField("code_night")
    private String codeNight;

    /** 当天最高温度 */
    @ApiModelProperty(value = "当天最高温度")
    @TableField("high")
    private String high;

    /** 当天最低温度 */
    @ApiModelProperty(value = "当天最低温度")
    @TableField("low")
    private String low;

    /** 降水概率，范围0~100，单位百分比（目前仅支持国外城市） */
    @ApiModelProperty(value = "降水概率，范围0~100，单位百分比（目前仅支持国外城市）")
    @TableField("precip")
    private String precip;

    /** 风向文字 */
    @ApiModelProperty(value = "风向文字")
    @TableField("wind_direction")
    private String windDirection;

    /** 风向角度，范围0~360 */
    @ApiModelProperty(value = "风向角度，范围0~360")
    @TableField("wind_direction_degree")
    private String windDirectionDegree;

    /** 风速，单位km/h（当unit=c时）、mph（当unit=f时） */
    @ApiModelProperty(value = "风速，单位km/h（当unit=c时）、mph（当unit=f时）")
    @TableField("wind_speed")
    private String windSpeed;

    /** 风力等级 */
    @ApiModelProperty(value = "风力等级")
    @TableField("wind_scale")
    private String windScale;

    /** 降水量，单位mm */
    @ApiModelProperty(value = "降水量，单位mm")
    @TableField("rainfall")
    private String rainfall;

    /** 相对湿度，0~100，单位为百分比 */
    @ApiModelProperty(value = "相对湿度，0~100，单位为百分比")
    @TableField("humidity")
    private String humidity;

    /** 中台插入时间 */
    @ApiModelProperty(value = "中台插入时间")
    @TableField("insert_time")
    private String insertTime;

    /** 中台插入时间 */
    @ApiModelProperty(value = "中台插入时间")
    @TableField("update_time")
    private String updateTime;


    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

}
