package com.artfess.manage.duty.manager.dto;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyWorkclass;
import com.artfess.uc.model.Org;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * cmgt_duty_workarrange
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-22
 */
@Data
@ApiModel(value = "CmgtDutyWorkarrangeDto", description = "排班信息DTO对象")
public class CmgtDutyWorkarrangeDto extends AutoFillModel<CmgtDutyWorkarrangeDto> {


    /**
     * 主键_ID
     */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /**
     * 排班日期
     */
    @ApiModelProperty(value = "排班日期")
    private LocalDate arrangeDate;


    /**
     * 班种
     */
    @ApiModelProperty(value = "班种")
    private String workclassId;

    private CmgtDutyWorkclass cmgtDutyWorkclass;


    @ApiModelProperty(value = "所属部门")
    private String orgId;

    private Org org;


    /**
     * 数据类型（0:人、1:组）
     */
    @ApiModelProperty(value = "数据类型（0:人、1:组）")
    private String dataType;


    /**
     * 队员ID
     */
    @ApiModelProperty(value = "队员ID")
    private String teammemberId;

    private String teammemberNames;

    private List<CmgtDutyTeamMemberDto> teamMembers;

    /**
     * 小组ID
     */
    @ApiModelProperty(value = "小组ID")
    private String teamId;


    private CmgtDutyTeam cmgtDutyTeam;


    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;


    /**
     * 出勤情况
     */
    @ApiModelProperty(value = "出勤情况")
    private String attendance;


    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sn;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String memo;


    /**
     * 删除标识，1已删除，0未删除
     */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;


    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    private Integer version;


    /**
     * 数据时间戳
     */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;


    /**
     * 前台传送多日期排班
     */
    private String[] selectDays;

    /**
     * 是否覆盖已有排班
     */
    private Boolean isCover;


}
