package com.artfess.manage.duty.manager.dto;

import com.artfess.base.entity.AutoFillModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;



/**
 * cmgt_duty_team
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-23
 */
@Data
@ApiModel(value="CmgtDutyTeamDto", description="勤务小组信息DTO对象")
public class CmgtDutyTeamDto extends AutoFillModel<CmgtDutyTeamDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 编号 */
    @ApiModelProperty(value = "编号")
    private String code;


    /** 名称 */
    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "组别名")
    private String alias;

    /** 组长 */
    @ApiModelProperty(value = "组长")
    private String headman;




    /** 负责区域 */
    @ApiModelProperty(value = "负责区域")
    private String area;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;




    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;




    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    private Integer version;




    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;




    @ApiModelProperty(value = "")
    private String orgId;




    @ApiModelProperty(value = "")
    private String orgName;




}
