package com.artfess.device.base.utils;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.vo.StatisticsVo;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Collections;
import org.apache.commons.compress.utils.Lists;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 黎沐华
 * @date 2022/6/8 12:24
 */
public class BizUtils {

    /**
     * 设置EasyPOI导出参数
     *
     * @param fileName 文件名
     * @return 导出参数
     */
    public static ExportParams getExportParams(String fileName) {
        ExportParams exportParams = new ExportParams(null, fileName);
        exportParams.setStyle(EasyPoiStyle.class);
        exportParams.setType(ExcelType.HSSF);
        return exportParams;
    }

    /**
     * 从字典中获取对应值的code
     *
     * @param dic   字典
     * @param value 值
     * @return
     */
    public static String getDicCodeByValue(List<DictModel> dic, String value) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (ele.getName().equals(value)) {
                return ele.getValue();
            }
        }
        return "";
    }

    /**
     * 从字典中获取对应code的值
     *
     * @param dic  字典
     * @param code code
     * @return
     */
    public static String getDicValueByCode(List<DictModel> dic, String code) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (ele.getValue().equals(code)) {
                return ele.getName();
            }
        }
        return "";
    }


    /**
     * 检查当前登录用户权限
     *
     * @param deviceLevel 设备权限等级
     * @return 允许/拒绝操作
     */
    public static Boolean checkLevel(DeviceInfo device) {
        Assert.notNull(device, "权限检查设备不能为空！");
        IUser user = ContextUtil.getCurrentUser();
        // 设备的level字段是必填项，不做空考虑
        if (
            BeanUtils.isEmpty(user) ||
            BeanUtils.isEmpty(user.getUserLevel())||
            user.getUserLevel() < device.getLevel()
        ) {
            throw new RuntimeException((StringUtil.isNotEmpty(device.getId()) ? "操作【"+device.getName()+"】":"")+
                    "权限不足：所需级别为【"+device.getLevel()+"】，当前用户【"+user.getFullname()+"】拥有的设备操作权限为【"+user.getUserLevel()+"】！");
        }
        return true;
    }

    /**
     * 处理空数据，统计时没有数据的时间也要加上，数据为0
     *
     * @param endtime   结束时间
     * @param inputTime 输入时间
     * @param data      数据
     * @return 空日期结果
     */
    public static List<StatisticsVo> handleEmptyResult(Integer endtime, String inputTime, List<StatisticsVo> data) {
        List<StatisticsVo> emptyResult = new ArrayList<>();
        out:
        for (int i = 1; i <= endtime; i++) {
            String time = inputTime + (i < 10 ? "-0" : "-") + i;
            for (StatisticsVo r : data) {
                if (r.getTime().equals(time)) {
                    continue out;
                }
            }
            emptyResult.add(new StatisticsVo(time, Lists.newArrayList()));
        }
        return emptyResult;
    }

    /**
     * Map按key排序
     * @param map 数据
     * @param isDesc 是否倒序
     * @return 排序后的Map
     */
    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map, boolean isDesc) {
        Map<K, V> result = Maps.newLinkedHashMap();
        if (isDesc) {
            map.entrySet().stream().sorted(Map.Entry.<K, V>comparingByKey().reversed())
                    .forEachOrdered(e -> result.put(e.getKey(), e.getValue()));
        } else {
            map.entrySet().stream().sorted(Map.Entry.<K, V>comparingByKey())
                    .forEachOrdered(e -> result.put(e.getKey(), e.getValue()));
        }
        return result;
    }

}
