package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.vo.CountVo;
import com.artfess.device.base.vo.DeviceCountVo;
import com.artfess.device.base.vo.FailureDeviceCountVo;
import com.artfess.device.base.vo.HomeRealTimeVo;
import com.artfess.device.base.vo.StatisticsVo;

import java.util.List;

/**
 * 设备信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceInfoManager extends BaseManager<DeviceInfo> {

    /**
     * 获取设备下拉接口
     * @param entity
     * @return
     */
    List<DeviceInfo> findAll(DeviceInfo entity);

    /**
     * 创建设备
     * @param t
     * @return
     */
    String createInfo(DeviceInfo t);

    /**
     * 修改设备
     * @param t
     * @return
     */
    String updateInfo(DeviceInfo t);

    /**
     * 根据产品id获取设备统计情况 1 全部设备 2在线 3离线 4未启用
     * @param productId 产品ID
     * @return
     */
    DeviceCountVo getDeviceInfo(String productId);

    /**
     * 启禁用设备
     * @param entity
     * @return
     */
    boolean modifyEnabled(DeviceInfo entity);

    /**
     * 修改设备状态
     * @param deviceCode  设备唯一标识
     * @param deviceType  告警设备类型【字典】（1：标识牌，2：低洼积水，3：危险源，4：路障，5：摄像头，6：蓝牙信标，7：信息发布屏）
     * @param status  设备状态【字典】（-1：报废，1：正常、2：故障、3、报警、9：其他）
     * @Return: java.lang.Boolean
     * @Author: chens
     * @Date: 2022/7/29 17:15
     */
    Boolean updateDeviceStatus(String deviceCode,String deviceType,String status);

    /**
     * 根据id获取设备信息
     * @param id
     * @return
     */
    DeviceInfo findById(String id);

    /**
     * 根据产品类型获取设备
     * @param queryFilter
     * @return
     */
    PageList<DeviceInfo> findByProductType(QueryFilter<DeviceInfo> queryFilter);

    /**
     * 根据设备id获取设备详情
     * @param id
     * @return
     */
    DeviceInfo detail(String id);

    /**
     * 根据设备类型获取
     * @param productType
     * @return
     */
    List<CountVo> statistics(String productType);

    /**
     * 设备故障次数统计
     * @param queryFilter
     * @return
     */
    PageList<FailureDeviceCountVo> failureStatistics(QueryFilter<DeviceInfo> queryFilter);

    /**
     * 分页查询设备
     * @param queryFilter
     * @return
     */
    PageList<DeviceInfo> findByPage(QueryFilter<DeviceInfo> queryFilter);

    PageList<DeviceInfo> failureEquipment(QueryFilter<DeviceInfo> queryFilter);

    /**
     * 首页设备统计
     * @return
     */
    List<StatisticsVo> homeStatistics();

    /**
     * 首页姿态分析
     * @return
     */
    List<StatisticsVo> currentStatusAnalyze();

    /**
     * 首页·近一月状态分析
     * @return
     */
    List<StatisticsVo> monthlyAnalyze(String code);

    /**
     * 首页实时数据
     * @return
     */
    List<HomeRealTimeVo> homeRealTime(String code);

}
