/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceVideoBaseManager;
import com.artfess.device.base.manager.DeviceVideoPointManager;
import com.artfess.device.base.model.DeviceVideoBase;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.model.DeviceVideoPointExtend;
import com.artfess.device.base.model.DeviceVideoZone;
import com.artfess.device.base.vo.CollectVo;
import com.artfess.device.base.vo.HaiKangRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/catalog/base/"})
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u89c6\u9891\u8bbe\u65bd"})
@ApiGroup(group={"device_biz"})
public class DeviceVideoBaseController {
    private static final Logger log = LoggerFactory.getLogger(DeviceVideoBaseController.class);
    @Autowired
    private DeviceVideoBaseManager baseService;
    @Autowired
    private DeviceVideoPointManager videoPointManager;

    @PostMapping(value={"/getCataLogBase"})
    @ApiOperation(value="\u83b7\u53d6\u89c6\u9891\u76ee\u5f55")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u89c6\u9891\u76ee\u5f55")
    public CommonResult<String> getCataLogBase() {
        List<DeviceVideoBase> list = this.baseService.getCataLogBase();
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u76ee\u5f55\u533a\u57df\u4fe1\u606f\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u76ee\u5f55\u533a\u57df\u4fe1\u606f\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody CollectVo t) {
        List<DeviceVideoZone> list = this.baseService.getTree(t);
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/asycCataLog"})
    @ApiOperation(value="\u540c\u6b65\u6d77\u5eb7\u76ee\u5f55\u4fe1\u606f")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u540c\u6b65\u6d77\u5eb7\u76ee\u5f55\u4fe1\u606f")
    public CommonResult<String> asycCataLog() {
        this.baseService.asycCataLog();
        return new CommonResult();
    }

    @PostMapping(value={"/asycCataLogZone"})
    @ApiOperation(value="\u6839\u636e\u76ee\u5f55\u4fe1\u606f\u540c\u6b65\u6d77\u5eb7\u533a\u57df\u4fe1\u606f\uff0c\u4f7f\u7528treeCode\uff08\u89c6\u9891\u76ee\u5f55code\uff09\u4f5c\u4e3a\u5165\u53c2")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u6839\u636e\u76ee\u5f55\u4fe1\u606f\u540c\u6b65\u6d77\u5eb7\u533a\u57df\u4fe1\u606f")
    public CommonResult<String> asycCataLogZone(@RequestBody HaiKangRequest haiKangRequest) {
        this.baseService.asycCataLogZone(haiKangRequest);
        return new CommonResult();
    }

    @PostMapping(value={"/asycZoneRes"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u7f16\u53f7\u540c\u6b65\u6d77\u5eb7\u76d1\u63a7\u70b9\u4fe1\u606f\uff0c\u4f7f\u7528regionIndexCode\uff08\u533a\u57df\u4e0b\u62c9code\uff09\u548ctreeCode\uff08\u89c6\u9891\u76ee\u5f55code\uff09\u4f5c\u4e3a\u5165\u53c2")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u6839\u636e\u533a\u57df\u7f16\u53f7\u540c\u6b65\u6d77\u5eb7\u76d1\u63a7\u70b9\u4fe1\u606f")
    public CommonResult<String> asycZoneRes(@RequestBody HaiKangRequest haiKangRequest) {
        HaiKangRequest asycRequest = new HaiKangRequest();
        this.baseService.asycZoneRes(asycRequest);
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u76d1\u63a7\u70b9")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u5206\u9875\u67e5\u8be2\u76d1\u6d4b\u70b9")
    public CommonResult<String> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceVideoBase> queryFilter) {
        log.info("\u5206\u9875\u67e5\u8be2\u76d1\u6d4b\u70b9\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(queryFilter));
        PageList<DeviceVideoPoint> page = this.baseService.findByPage(queryFilter);
        log.info("\u5206\u9875\u67e5\u8be2\u76d1\u6d4b\u70b9\u54cd\u5e94\u6570\u636e:{}", (Object)JSON.toJSONString(page));
        return CommonResult.success(page, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/hkPreviewURLs"})
    @ApiOperation(value="\u6839\u636e\u6d77\u5eb7\u76d1\u63a7\u70b9\u83b7\u53d6\u89c6\u9891\u6d41\u63a5\u53e3")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.ADD, description="\u6839\u636e\u76d1\u63a7\u70b9\u83b7\u53d6\u89c6\u9891\u6d41\u63a5\u53e3")
    public CommonResult<String> hkPreviewURLs(@ApiParam(name="code", value="\u89c6\u9891\u70b9\u4f4d\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="module", value="\u89c6\u9891\u6d41\u534f\u8bae\uff08rtsp,rtmp,hls,ws,wss\uff09", required=true) @RequestParam String module) {
        String result = this.baseService.hkPreviewURLs(code, module);
        return CommonResult.success((Object)result, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @RequestMapping(value={"/zgPreviewURLs"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7d2b\u5149\u534e\u667a\u76d1\u63a7\u70b9\u83b7\u53d6\u89c6\u9891\u6d41\u63a5\u53e3", httpMethod="POST", notes="\u6839\u636e\u7d2b\u5149\u534e\u667a\u76d1\u63a7\u70b9\u83b7\u53d6\u89c6\u9891\u6d41\u63a5\u53e3")
    public CommonResult<String> zgPreviewURLs(@ApiParam(name="code", value="\u89c6\u9891\u70b9\u4f4d\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="module", value="\u89c6\u9891\u6d41\u534f\u8bae\uff081:RTSP,2:RTMP,3:HLS,4:HLS_SSL,5:HTTP FLV,6:HTTPS FLV,7:WS FLV,8:WSS FLV\uff09", required=true) @RequestParam Integer module) {
        String url = this.videoPointManager.getZGVideoUri(code, module, false);
        return new CommonResult(true, "", (Object)url);
    }

    @PostMapping(value={"/findByZoneCode"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u4fe1\u606f\u83b7\u53d6\u76d1\u63a7\u70b9\u5217\u8868", response=DeviceVideoPoint.class)
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u6839\u636e\u533a\u57df\u4fe1\u606f\u83b7\u53d6\u76d1\u63a7\u70b9\u5217\u8868")
    public CommonResult<String> findByZoneCode(@ApiParam(name="model", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceVideoBase> queryFilter) {
        log.info("\u6839\u636e\u533a\u57df\u4fe1\u606f\u83b7\u53d6\u76d1\u63a7\u70b9\u5217\u8868\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(queryFilter));
        List<DeviceVideoPoint> list = this.baseService.findByZoneCode(queryFilter);
        log.info("\u6839\u636e\u533a\u57df\u4fe1\u606f\u83b7\u53d6\u76d1\u63a7\u70b9\u5217\u8868\u54cd\u5e94\u6570\u636e:{}", (Object)JSON.toJSONString(list));
        return CommonResult.success(list, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/getAllTree"})
    @ApiOperation(value="\u83b7\u53d6\u76ee\u5f55\u533a\u57df\u4fe1\u606f\u548c\u76d1\u63a7\u70b9\u4fe1\u606f\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u76ee\u5f55\u533a\u57df\u4fe1\u606f\u548c\u76d1\u63a7\u70b9\u4fe1\u606f\u6811")
    public CommonResult<String> getAllTree(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody CollectVo t) {
        List<DeviceVideoZone> list = this.baseService.getAllTree(t);
        return CommonResult.success(list, null);
    }

    @PutMapping(value={"/updateById"})
    @ApiOperation(value="\u4fee\u6539\u70b9\u4f4d\u6269\u5c55\u4fe1\u606f")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) DeviceVideoPointExtend t) {
        String id = this.videoPointManager.updateInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{code}"})
    @ApiOperation(value="\u83b7\u53d6\u89c6\u9891\u70b9\u4f4d\u4fe1\u606f")
    public DeviceVideoPoint getById(@ApiParam(name="code", value="\u5b9e\u4f53id") @PathVariable String code) {
        return this.videoPointManager.findByCode(code);
    }
}

