/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms.impl;

import com.artfess.application.config.AppPushConfig;
import com.artfess.application.model.AppPushContent;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.vo.ClientInfo;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppPushHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppPushHandler.class);
    @Resource
    AppPushConfig config;

    public void pushIndexMsgToList(AppPushContent content, ClientInfo ... clientInfo) {
    }

    public void pushIndexMsgToSingle(ClientInfo clientInfo, AppPushContent content) throws IOException {
        IGtPush push = new IGtPush(this.config.getHost(), this.config.getAppKey(), this.config.getMasterSecret());
        NotificationTemplate template = this.getIndexMsgTemplate(content.getTitle(), content.getContent(), JsonUtil.toJson(content.getParams()));
        SingleMessage message = new SingleMessage();
        message.setOffline(true);
        message.setOfflineExpireTime(259200000L);
        message.setData((ITemplate)template);
        message.setPushNetWorkType(0);
        message.setStrategyJson("{\"default\":4,\"ios\":4,\"st\":4,\"hw\":4,\"xm\":4,\"vv\":4,\"mz\":4,\"op\":4}");
        Target target = new Target();
        target.setAppId(this.config.getAppId());
        target.setClientId(clientInfo.getClientId());
        IPushResult ret = null;
        try {
            ret = push.pushMessageToSingle(message, target);
        }
        catch (RequestException e) {
            logger.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0capp\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
            ret = push.pushMessageToSingle(message, target, e.getRequestId());
        }
        if (ret != null) {
            logger.warn("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c:" + ret.getResponse().toString());
        } else {
            logger.error("\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
        }
    }

    public TransmissionTemplate transmissionTemplateDemo(String title, String content, String transmissionContent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(this.config.getAppId());
        template.setAppkey(this.config.getAppKey());
        template.setTransmissionType(2);
        template.setTransmissionContent("\u8bf7\u8f93\u5165\u9700\u8981\u900f\u4f20\u7684\u5185\u5bb9");
        return template;
    }

    public NotificationTemplate getIndexMsgTemplate(String title, String content, String transmissionContent) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.config.getAppId());
        template.setAppkey(this.config.getAppKey());
        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(content);
        style.setBadgeAddNum(Integer.valueOf(1));
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        style.setChannelLevel(4);
        template.setStyle((AbstractNotifyStyle)style);
        template.setTransmissionType(2);
        template.setTransmissionContent(transmissionContent);
        return template;
    }
}

