package com.artfess.file.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.model.FileConfig;
import com.artfess.file.params.FileStorageConfigDTO;
import org.apache.poi.ss.formula.functions.T;

/**
 * 附件配置信息 服务类
 *
 * @company rzx
 * @author wh
 * @since 2021-03-04
 */
public interface FileConfigManager extends BaseManager<FileConfig> {

    /**
     * 分页查询
     * @param queryFilter
     * @return
     */
    PageList<FileConfig> queryPage(QueryFilter<FileConfig> queryFilter);

    /**
    * @Description: 根据ID获取
    * @param id
    * @Return: com.artfess.file.model.FileConfig
    * @Author: chens
    * @Date: 2021/6/25 12:49
    */
    FileConfig getOneById(String id);
    /**
     * @Description:  保存附件配置
     * @param fileConfig  系统附件配置
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2020/5/6 17:10
     */
    String insertFileConfig(FileConfig fileConfig);

    /**
     * 批量删除附件配置
     * @param ids
     */
    void deleteFileConfig(String ids);

    /**
     * @Description: 根据ID查询附件配置信息
     * @param id  附件配置信息id
     * @Author: chens
     * @Date: 2020/5/7 15:40
     */
    FileConfig loadFileConfig(String id);

    /**
     * @Description: 根据编码查询附件配置信息
     * @param code  附件配置信息编码
     * @Author: chens
     * @Date: 2020/5/7 15:40
     */
    FileStorageConfigDTO getFileConfigByCode(String code);

    /**
     * @Description: 修改附件配置
     * @param fileConfig   系统附件配置
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2020/5/7 10:39
     */
    String updateFileConfig(FileConfig fileConfig);


}
