package com.artfess.workflow.runtime.manager.impl;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.bpm.api.constant.DecideType;
import com.artfess.bpm.exception.ApproveTaskException;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.workflow.runtime.dao.BpmTaskTransDao;
import com.artfess.workflow.runtime.manager.BpmTaskTransManager;
import com.artfess.workflow.runtime.model.BpmTaskTrans;

@Service("bpmTaskTransManager")
public class BpmTaskTransManagerImpl extends BaseManagerImpl<BpmTaskTransDao, BpmTaskTrans> implements BpmTaskTransManager{
	
    @Resource
    DefaultTaskTransService deafultTaskTransService;
	@Override
	public BpmTaskTrans getByTaskId(String taskId) {
		
		return baseMapper.getByTaskId(taskId);
	}

    @Override
    @Transactional
    public void taskToInquReply(DefaultBpmCheckOpinion dbo)throws Exception{
        //征询回复
        if(dbo.getStatus().equals("inqu_reply")){
            deafultTaskTransService.taskToInquReply(dbo.getFormData(),dbo.getTaskId(), DecideType.AGREE.getKey(), "inner", dbo.getOpinion(),false,dbo.getFiles(),dbo.getZfiles());
        }else{
            throw new ApproveTaskException("当前任务已办理，不可重复办理，");
        }
    }

	@Override
	@Transactional
	public void removeByInstId(String instanceId) {
		baseMapper.removeByInstId(instanceId);
	}

	@Override
	public void userAddSignFeedback(DefaultBpmCheckOpinion dbo) throws Exception {
        if(dbo.getStatus().equals("inqu_reply")){
            deafultTaskTransService.userAddSignFeedback(dbo.getTaskId(), DecideType.AGREE.getKey(), "inner", dbo.getOpinion(),false,dbo.getFiles(),dbo.getZfiles());
        }else{
            throw new ApproveTaskException("当前任务已办理，不可重复办理，");
        }
	}
}
