package com.artfess.sysConfig.persistence.param;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DictModel implements Serializable {
    private static final long serialVersionUID = 1L;

    public DictModel() {
    }

    public DictModel(String value, String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * 字典value
     */
    private String value;
    /**
     * 字典文本
     */
    private String name;

    /**
     * 特殊用途： JgEditableTable
     *
     * @return
     */
    public String getTitle() {
        return this.name;
    }

}
