package com.artfess.service.manager.impl;

import com.artfess.base.exception.NotFoundException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.service.dao.ServiceParamDao;
import com.artfess.service.dao.ServiceSetDao;
import com.artfess.service.manager.ServiceSetManager;
import com.artfess.service.model.ServiceParam;
import com.artfess.service.model.ServiceSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class ServiceSetManagerImpl extends BaseManagerImpl<ServiceSetDao, ServiceSet> implements ServiceSetManager{
	@Resource
	ServiceParamDao serviceParamDao;
	
	@Override
	public ServiceSet getByAlias(String alias) {
		ServiceSet serviceSet = baseMapper.getByAlias(alias);
		if(BeanUtils.isEmpty(serviceSet)) {
			throw new NotFoundException(String.format("未找到别名为: %s 的记录", alias));
		}
		String setId = serviceSet.getId();
		List<ServiceParam> paramList = serviceParamDao.getBySetId(setId);
		serviceSet.setServiceParamList(paramList);
		return serviceSet;
	}
	
	@Override
	@Transactional
	public void saveData(ServiceSet serviceSet) {
		String setId = serviceSet.getId();
		if(StringUtil.isEmpty(setId)) {
			setId = UniqueIdUtil.getSuid();
			serviceSet.setId(setId);
			this.create(serviceSet);
		}
		else {
			this.update(serviceSet);
		}
		serviceParamDao.removeBySetId(setId);
		List<ServiceParam> sysServiceParamList = serviceSet.getServiceParamList();
		for(ServiceParam param : sysServiceParamList) {
			param.setSetId(setId);
			param.setId(UniqueIdUtil.getSuid());
			serviceParamDao.insert(param);
		}
	}

	@Override
	@Transactional
	public void removeByIds(String... ids) {
		for(String id : ids) {
			serviceParamDao.removeBySetId(id);
			this.remove(id);
		}
	}
}
