package com.artfess.mail.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.mail.model.MailAttachment;

import java.util.List;

/**
 * 外部邮件附件表 处理接口
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author maoww
 * @email maoww@jee-soft.cn
 * @date 2018年6月6日
 */
public interface MailAttachmentManager extends BaseManager<MailAttachment>{
	
	/**
	 * 根据邮箱ID获取邮箱附件
	 * @param mailId 邮箱ID
	 * @return		   返回邮箱附件实体集合
	 */
	List<MailAttachment> getByMailId(String mailId);

	/**
	 * 更新附件文件路径
	 * @param fileName 文件名称
	 * @param mailId   邮箱ID
	 * @param filePath 文件路径
	 */
	void updateFilePath(String fileName, String mailId, String filePath);

	/**
	 * 根据OutMail实体的fileIds，构建OutMailAttachment列表
	 * @param fileIds 附件ids 
	 * @return 		     返回邮箱附件实体集合
	 */
	List<MailAttachment> getByOutMailFileIds(String fileIds)throws Exception;
	 
	/**
	 * 根据邮件ID删除附件
	 * @param mailId 邮箱ID
	 */
	void delByMailId(String mailId);
	
}
