package com.artfess.file.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 文件分片记录
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2021-12-29
 */
@ApiModel(value="PortalSysFileZoneRecord对象", description="文件分片记录")
@TableName("PORTAL_SYS_FILE_ZONE")
public class FileZone extends BaseModel<FileZone> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "分片ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "分片名称")
    @TableField("ZONE_NAME_")
    private String zoneName;

    @ApiModelProperty(value = "分片的文件路径")
    @TableField("ZONE_PATH_")
    private String zonePath;

    @ApiModelProperty(value = "分片MD5")
    @TableField("ZONE_MD5_")
    private String zoneMd5;


    @ApiModelProperty(value = "总的分片数")
    @TableField("ZONE_TOTAL_COUNT_")
    private Integer zoneTotalCount;

    @ApiModelProperty(value = "总的文件大小")
    @TableField("ZONE_TOTAL_SIZE_")
    private Long zoneTotalSize;

    @ApiModelProperty(value = "分片起始位置")
    @TableField("ZONE_START_SIZE_")
    private Long zoneStartSize;

    @ApiModelProperty(value = "分片结束位置")
    @TableField("ZONE_END_SIZE_")
    private Long zoneEndSize;

    @ApiModelProperty(value = "总文件的MD5值")
    @TableField("ZONE_TOTAL_MD5_")
    private String zoneTotalMd5;

    @ApiModelProperty(value = "当前分片索引")
    @TableField("ZONE_NOW_INDEX_")
    private Integer zoneNowIndex;

    @ApiModelProperty(value = "分片文件后缀")
    @TableField("ZONE_SUFFIX_")
    private String zoneSuffix;

    @ApiModelProperty(value = "分片上传时间")
    @TableField("ZONE_RECORD_TIME_")
    private LocalDateTime zoneRecordTime;

    @TableField("tenant_id_")
    @ApiModelProperty(name = "tenantId", notes = "租户id")
    protected String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getZoneName() {
        return zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getZonePath() {
        return zonePath;
    }

    public void setZonePath(String zonePath) {
        this.zonePath = zonePath;
    }

    public String getZoneMd5() {
        return zoneMd5;
    }

    public void setZoneMd5(String zoneMd5) {
        this.zoneMd5 = zoneMd5;
    }

    public Integer getZoneTotalCount() {
        return zoneTotalCount;
    }

    public void setZoneTotalCount(Integer zoneTotalCount) {
        this.zoneTotalCount = zoneTotalCount;
    }

    public Long getZoneTotalSize() {
        return zoneTotalSize;
    }

    public void setZoneTotalSize(Long zoneTotalSize) {
        this.zoneTotalSize = zoneTotalSize;
    }

    public Long getZoneStartSize() {
        return zoneStartSize;
    }

    public void setZoneStartSize(Long zoneStartSize) {
        this.zoneStartSize = zoneStartSize;
    }

    public Long getZoneEndSize() {
        return zoneEndSize;
    }

    public void setZoneEndSize(Long zoneEndSize) {
        this.zoneEndSize = zoneEndSize;
    }

    public String getZoneTotalMd5() {
        return zoneTotalMd5;
    }

    public void setZoneTotalMd5(String zoneTotalMd5) {
        this.zoneTotalMd5 = zoneTotalMd5;
    }

    public Integer getZoneNowIndex() {
        return zoneNowIndex;
    }

    public void setZoneNowIndex(Integer zoneNowIndex) {
        this.zoneNowIndex = zoneNowIndex;
    }

    public String getZoneSuffix() {
        return zoneSuffix;
    }

    public void setZoneSuffix(String zoneSuffix) {
        this.zoneSuffix = zoneSuffix;
    }

    public LocalDateTime getZoneRecordTime() {
        return zoneRecordTime;
    }

    public void setZoneRecordTime(LocalDateTime zoneRecordTime) {
        this.zoneRecordTime = zoneRecordTime;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return "FileZone{" +
                "id='" + id + '\'' +
                ", zoneName='" + zoneName + '\'' +
                ", zonePath='" + zonePath + '\'' +
                ", zoneMd5='" + zoneMd5 + '\'' +
                ", zoneTotalCount=" + zoneTotalCount +
                ", zoneTotalSize=" + zoneTotalSize +
                ", zoneStartSize=" + zoneStartSize +
                ", zoneEndSize=" + zoneEndSize +
                ", zoneTotalMd5='" + zoneTotalMd5 + '\'' +
                ", zoneNowIndex=" + zoneNowIndex +
                ", zoneSuffix='" + zoneSuffix + '\'' +
                ", zoneRecordTime=" + zoneRecordTime +
                ", tenantId='" + tenantId + '\'' +
                '}';
    }
}
