package com.artfess.file.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.FileConfig;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.persistence.dao.FileConfigDao;
import com.artfess.file.persistence.manager.FileConfigManager;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.List;

/**
 * 附件配置信息 服务实现类
 *
 * @company rzx
 * @author wh
 * @since 2021-03-04
 */
@Service
public class FileConfigManagerImpl extends BaseManagerImpl<FileConfigDao, FileConfig> implements FileConfigManager {

    @Autowired
    FileStorageManager fileStorageManager;

    @Override
    public PageList<FileConfig> queryPage(QueryFilter<FileConfig> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<FileConfig> result=baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<FileConfig>(result);
    }

    @Override
    public FileConfig getOneById(String id) {
        Assert.hasText(id, "ID不能为空！");
        FileConfig fileConfig = baseMapper.getOneById(id);
        return fileConfig;
    }

    @Override
    @Transactional
    public String insertFileConfig(FileConfig fileConfig) {
        Assert.notNull(fileConfig, "附件配置信息不能为空！");
        boolean flag = this.checkSameField("", "CODE_",fileConfig.getCode());
        if(!flag){
            throw new ApplicationException("编码重复请修改！");
        }
        baseMapper.insert(fileConfig);
        return fileConfig.getId();
    }

    @Override
    @Transactional
    public void deleteFileConfig(String ids) {
        Assert.hasText(ids, "参数ids不能为空！");
        List<String> idsList = Arrays.asList(ids.split(","));
        baseMapper.deleteBatchIds(idsList);
    }

    @Override
    public FileConfig loadFileConfig(String id) {
        Assert.hasText(id, "参数id不能为空！");
        FileConfig fileConfig = baseMapper.selectById(id);
        return fileConfig;
    }

    @Override
    public FileStorageConfigDTO getFileConfigByCode(String code) {
        Assert.hasText(code, "编码不能为空");
        List<FileStorageConfigDTO> list = baseMapper.getFileConfigByCode(code);
        if(BeanUtils.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public String updateFileConfig(FileConfig fileConfig) {
        Assert.notNull(fileConfig, "附件配置信息不能为空！");
        boolean flag = this.checkSameField(fileConfig.getId(), "CODE_",fileConfig.getCode());
        if(!flag){
            throw new ApplicationException("编码重复请修改！");
        }
        this.update(fileConfig);
        return fileConfig.getId();
    }

}
