package com.artfess.portal.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysAppMenuManager;
import com.artfess.sysConfig.persistence.model.SysAppMenu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 * 描述：应用菜单 控制器类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-21 10:12:59
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/portal/sysAppMenu/v1")
@Api(tags = "sysAppMenuController")
public class SysAppMenuController extends BaseController<SysAppMenuManager, SysAppMenu> {
    @Resource
    SysAppMenuManager sysAppMenuManager;

    /**
     * 新增应用菜单
     *
     * @param sysAppMenu
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新应用菜单数据", httpMethod = "POST", notes = "新增,更新应用菜单数据")
    public CommonResult<String> save(@ApiParam(name = "sysAppMenu", value = "应用菜单业务对象", required = true) @RequestBody SysAppMenu sysAppMenu) throws Exception {
        String msg = "添加应用菜单成功";
        if (StringUtil.isEmpty(sysAppMenu.getId())) {
            sysAppMenuManager.create(sysAppMenu);
        } else {
            sysAppMenuManager.update(sysAppMenu);
            msg = "更新应用菜单成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除应用菜单记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除应用菜单记录", httpMethod = "DELETE", notes = "批量删除应用菜单记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        sysAppMenuManager.removeByIds(ids);
        return new CommonResult<String>(true, "删除成功");
    }

    @GetMapping(value = "/getTree")
    @ApiOperation(value = "获取APP菜单树", httpMethod = "GET", notes = "获取APP菜单树")
    public List<SysAppMenu> getTree(@RequestParam("appId") String appId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("app_id_", appId);
        List<SysAppMenu> menus = baseService.list(wrapper);
        return BeanUtils.listToTree(menus);
    }
}
