package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 设备产品信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@FieldRepeat(fields = {"code","name"},message = "产品名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceProductInfo对象", description="设备产品信息")
public class DeviceProductInfo extends AutoFillModel<DeviceProductInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定产品id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择产品分类",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "产品分类ID")
    @TableField("type_id_")
    private String typeId;

    @NotBlank(message = "请输入产品编码标识",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "产品编码标识")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请输入产品名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "产品名称")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请选择智能分类",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "智能分类（0：非智能 ，1：智能产品）")
    @TableField("is_intellect_")
    private String isIntellect;

    @NotBlank(message = "请选择设备类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备类型（1：直连设备，2：网关子设备，3：网关设备）")
    @TableField("device_type_")
    private String deviceType;

    @ApiModelProperty(value = "ID全路径")
    @TableField("full_id_")
    private String fullId;

    @ApiModelProperty(value = "名称全路径")
    @TableField("full_name_")
    private String fullName;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "发布状态【字典】（0：未发布 ，1：已发布）")
    @TableField(value = "publish_status_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String publishStatus;

    @ApiModelProperty(value = "产品图标")
    @TableField("icon_")
    private String icon;




}
