package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Optional;

/**
 * 产品类型枚举
 */
@Getter
public enum ProductTypeEnum {
    /**
     * 删除
     */
    barricade("barricade", "升降路障", "4", "device_data_barricade"),

    hazard("hazard", "危险源监测", "3", "device_data_water"),

    water("water", "低洼积水监测", "2", "device_data_hazard"),

    signboaerd("signboaerd", "标识牌监测", "1", "device_data_signboaerd"),

    ;

    ProductTypeEnum(String code, String desc, String type, String table) {
        this.code = code;
        this.desc = desc;
        this.type = type;
        this.table = table;
    }

    private String code;

    private String desc;

    private String type;

    private String table;

    public static String findByCode(String code){
        if(StringUtils.isEmpty(code)){
            return null;
        }
        ProductTypeEnum[] values = values();
        for (ProductTypeEnum state : values) {
            if (state.getCode().equals(code)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static ProductTypeEnum getByType(String val) {
        ProductTypeEnum[] values = ProductTypeEnum.values();
        Optional<ProductTypeEnum> first = Arrays.stream(values).filter(e -> e.getCode().equals(val)).findFirst();
        return !first.isPresent() ? null : first.get();
    }

    public static String getType(String code) {
        if(StringUtils.isEmpty(code)){
            return null;
        }
        ProductTypeEnum[] values = values();
        for (ProductTypeEnum state : values) {
            if (state.getCode().equals(code)) {
                return state.getType();
            }
        }
        return null;
    }

    public static String getTable(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        ProductTypeEnum[] values = values();
        for (ProductTypeEnum v : values) {
            if (v.getCode().equals(code)) {
                return v.getTable();
            }
        }
        return null;
    }
}
