/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.dingding.utils;

import com.artfess.base.dingding.exception.InvokeDingTalkException;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class AccessTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenUtil.class);

    public static String getAccessToken(String appKey, String appSecret) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest request = new OapiGettokenRequest();
        request.setAppkey(appKey);
        request.setAppsecret(appSecret);
        request.setHttpMethod(HttpMethod.GET.name());
        try {
            OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            if (response.isSuccess()) {
                return response.getAccessToken();
            }
            throw new InvokeDingTalkException(response.getErrorCode(), response.getErrmsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            throw new InvokeDingTalkException(e.getErrCode(), e.getErrMsg());
        }
    }
}

