package com.artfess.application.util;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.base.util.Base64;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.integrate.consts.WeChatOffAccConsts;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.model.msg.WxBaseMessage;
import com.artfess.integrate.model.msg.impl.WxNewsMessage;
import com.artfess.integrate.util.WechatOffAccTokenUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信工具类
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年11月13日
 */
public class WeiXinUtil {

    /**
     * 发送模板消息给企业成员。（企业微信）
     *
     * @param msg
     * @return
     * @throws Exception
     */
    public static String sendTextMessage(WxBaseMessage msg) throws Exception {
        String resultJson = HttpUtil.sendHttpsRequest(WeChatWorkConsts.getSendMsgUrl(), JsonUtil.toJson(msg), WeChatWorkConsts.METHOD_POST);
        return resultJson;
    }

    /**
     * 发送新闻消息给指定用户。
     *
     * @param msg
     * @return
     * @throws Exception
     */
    public static String sendNewsMessage(WxNewsMessage msg) throws Exception {
        String resultJson = HttpUtil.sendHttpsRequest(WeChatWorkConsts.getSendMsgUrl(), msg.toString(), WeChatWorkConsts.METHOD_POST);
        return resultJson;
    }

    /**
     * 发送新闻消息给指定用户。（微信公众号）
     *
     * @param msg
     * @return
     * @throws Exception
     */
    public static String sendWeiXinMessage(String msg) throws Exception {
        String resultJson = HttpUtil.sendHttpsRequest(WeChatOffAccConsts.send(WechatOffAccTokenUtil.getToken()), msg, WeChatOffAccConsts.METHOD_POST);
        return resultJson;
    }

    /**
     * 企业微信：转换pc端的url
     *
     * @return
     * @throws Exception
     */
    public static String renderMobileUrl(JmsMessage jmsMessage) throws Exception {
        String newUrl = "";
        try {
            Document doc = Jsoup.parseBodyFragment(jmsMessage.getContent());
            Elements elms = doc.getElementsByTag("a");
            Map<String, Object> vars = jmsMessage.getExtendVars();
            Map<String, Object> params = new HashMap<>();
            params.put("taskId", vars.getOrDefault("taskId", ""));
            params.put("instId", vars.getOrDefault("instId", ""));
            params.put("templateType", vars.getOrDefault("templateType", ""));
            params.put("templateAlias", jmsMessage.getTemplateAlias());
            for (Element e : elms) {
                String oldUrl = e.attr("href");
                params.put("originUrl", oldUrl);
                String paramStr = Base64.getBase64(JsonUtil.toJson(params));
                newUrl = WeChatWorkConsts.getWxAuthorize(paramStr);
                jmsMessage.setContent(jmsMessage.getContent().replace(oldUrl, newUrl));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return newUrl;
    }

    /**
     * 微信公众号 转换pc端的url
     *
     * @param jmsMessage
     * @return
     */
    public static String renderOffAccUrl(JmsMessage jmsMessage) {
        String newUrl = "";
        try {
            Document doc = Jsoup.parseBodyFragment(jmsMessage.getContent());
            Elements elms = doc.getElementsByTag("a");
            Map<String, Object> vars = jmsMessage.getExtendVars();
            Map<String, Object> params = new HashMap<>();
            params.put("taskId", vars.getOrDefault("taskId", ""));
            params.put("instId", vars.getOrDefault("instId", ""));
            params.put("templateType", vars.getOrDefault("templateType", ""));
            params.put("templateAlias", jmsMessage.getTemplateAlias());
            for (Element e : elms) {
                String oldUrl = e.attr("href");
                params.put("originUrl", oldUrl);
                String paramStr = Base64.getBase64(JsonUtil.toJson(params));
                newUrl = WeChatOffAccConsts.getWxAuthorize(paramStr);
                jmsMessage.setContent(jmsMessage.getContent().replace(oldUrl, newUrl));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return newUrl;
    }
}
