package com.artfess.application.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.application.model.MessageRead;
import com.artfess.application.model.SysMessage;
import com.artfess.application.params.MessaboxVo;
import com.artfess.application.persistence.manager.MessageReadManager;
import com.artfess.application.persistence.manager.SysMessageManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 内部消息
 *
 * @author zhangxianwen
 * @company 阿特菲斯信息技术有限公司
 * @email zhangxw@jee-soft.cn
 * @date 2018年7月17日
 */
@SuppressWarnings({"rawtypes", "unchecked"})
@RestController
@RequestMapping("/msg/messageReceiver/v1")
@Api(tags = "内部消息接收")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class MessageReceiverController extends BaseController {
    @Resource
    MessageReadManager messageReadManager;
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    IUserService iUserService;

    @RequestMapping(value = "list", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "消息列表", httpMethod = "POST", notes = "消息列表")
    public PageList<SysMessage> listJson(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("receiverId", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<SysMessage> sysMessageList = sysMessageManager.getMsgByUserId(queryFilter);
        List<SysMessage> list = sysMessageList.getRows();
        PageList<SysMessage> newSysMessageList = new PageList<SysMessage>();
        //消息类型值得转换
//		for (int i = 0; i < list.size(); i++) {
//			SysMessage sysMessage = list.get(i);
//			String messageType= MessageTypeUtil.getValue(sysMessage.getMessageType());
//			sysMessage.setMessageType(messageType);
//			newSysMessageList.getRows().add(sysMessage);
//		}
        newSysMessageList.setRows(list);
        newSysMessageList.setPage(sysMessageList.getPage());
        newSysMessageList.setPageSize(sysMessageList.getPageSize());
        newSysMessageList.setTotal(sysMessageList.getTotal());
        return newSysMessageList;
    }

    @RequestMapping(value = "listNoPage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "消息列表(不分页)", httpMethod = "POST", notes = "消息列表(不分页)")
    public PageList<SysMessage> listJsonNoPage() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("receiverId", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
        HashMap<String, Object> map = new HashMap<>();
        map.put("receiveTime", 1);
        queryFilter.setParams(map);
        PageList<SysMessage> sysMessageList = sysMessageManager.getMsgByUserId(queryFilter);
        List<SysMessage> list = sysMessageList.getRows();
        PageList<SysMessage> newSysMessageList = new PageList<SysMessage>();
        //消息类型值得转换
//		for (int i = 0; i < list.size(); i++) {
//			SysMessage sysMessage = list.get(i);
//			String messageType= MessageTypeUtil.getValue(sysMessage.getMessageType());
//			sysMessage.setMessageType(messageType);
//			newSysMessageList.getRows().add(sysMessage);
//		}
        newSysMessageList.setRows(list);
        newSysMessageList.setPage(sysMessageList.getPage());
        newSysMessageList.setPageSize(sysMessageList.getPageSize());
        newSysMessageList.setTotal(sysMessageList.getTotal());
        return newSysMessageList;
    }

    @RequestMapping(value = "edit", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "消息编辑页面信息", httpMethod = "GET", notes = "消息编辑页面信息")
    public MessageRead edit(@ApiParam(name = "id", value = "主键", required = false) @RequestParam String id) throws Exception {
        MessageRead messageRead = null;
        if (StringUtil.isNotEmpty(id)) {
            messageRead = messageReadManager.get(id);
        }
        return messageRead;
    }

    @RequestMapping(value = "get", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "消息明细页面", httpMethod = "GET", notes = "消息明细页面")
    public SysMessage get(@ApiParam(name = "id", value = "主键", required = false) @RequestParam String id) throws Exception {
        SysMessage sysMessage = sysMessageManager.get(id);
        IUser user = ContextUtil.getCurrentUser();
        //保存到已读表
        messageReadManager.addMessageRead(id, user);
        sysMessageManager.update(sysMessage);
        return sysMessage;
    }

    @RequestMapping(value = "remove", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "删除消息记录", httpMethod = "DELETE", notes = "删除消息记录")
    public CommonResult<String> remove(@ApiParam(name = "ids", value = "任务记录ID，多个用“,”号分隔", required = true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty(ids)) {
            aryIds = ids.split(",");
        }
        sysMessageManager.removeByIds(Arrays.asList(aryIds));
        return new CommonResult<String>(true, "删除消息成功", "");
    }

    @RequestMapping(value = "getMessBoxInfo", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取用户已读未读消息", httpMethod = "GET", notes = "获取用户已读未读消息")
    public MessaboxVo getMessBoxInfo(@ApiParam(name = "account", value = "用户账号", required = true) @RequestParam String account) throws Exception {
        IUser user = iUserService.getUserByAccount(account);
        int messCount = 0;
        int noReadMessCount = 0;
        if (BeanUtils.isNotEmpty(user)) {
            QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("receiverId", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
            PageList<SysMessage> sysMessageList = sysMessageManager.getMsgByUserId(queryFilter);
            messCount = (int) sysMessageList.getTotal();
            if (messCount > 0) {
                for (SysMessage message : sysMessageList.getRows()) {
                    if (BeanUtils.isEmpty(message.getReceiveTime())) {
                        ++noReadMessCount;
                    }
                }
            }
        }
        return new MessaboxVo(messCount, noReadMessCount);
    }

    @RequestMapping(value = "mark", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "标记为已读", httpMethod = "GET", notes = "标记为已读")
    public CommonResult<String> mark(@ApiParam(name = "ids", value = "任务记录ID，多个用“,”号分隔", required = true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty(ids)) {
            aryIds = ids.split(",");
        }
        IUser user = ContextUtil.getCurrentUser();
        //保存到已读表
        for (String string : aryIds) {
            messageReadManager.addMessageRead(string, user);
        }
        return new CommonResult<String>(true, "标记成功", "");
    }

    @RequestMapping(value = "getMsgbadge", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取当前用户未读消息数量", httpMethod = "GET", notes = "获取当前用户未读消息数量")
    public CommonResult<Integer> getMsgbadge() throws Exception {
        int badge = sysMessageManager.getNotReadMsgNum(ContextUtil.getCurrentUserId());
        return new CommonResult<Integer>(true, "获取成功", badge);
    }
}
