package com.artfess.uc.api.util;

import java.io.IOException;
import java.util.Map;
import java.util.Set;

public interface IPermissionCalc {
	
	/**
	 * 获取权限规则的当前人配置数据
	 * 比如当前算法为用户角色：那么获取当前人的角色
	 * @return 当前人配置数据
	 */
	public Map<String,Set<String>> getCurrentProfiles();
	
	/**
	 * 权限计算
	 * @param json
     * 参数说明：
     * json:传入的配置
     * 数据格式如下：
     * {"type":"user","id":"1,2","name":"ray,tom"}
	 * @param currentMap
     * currentMap:
     * 当前算法计算出来的当前人的配置，比如某个人属于某几个角色
	 * @return 是否有权限
	 * @throws IOException 
	 */
	public boolean hasRight(String json, Map<String, Set<String>> currentMap) throws IOException;

}
