package com.artfess.manage.safty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * cmgt_safty_training_project
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyTrainingProject对象", description="培训项目")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyTrainingProject extends ManageBaseModel<CmgtSaftyTrainingProject> {


    /** 培训类型 */
    @ApiModelProperty(value = "培训类型")
    @TableField("training_type_")
    @NotBlank(message = "培训类型",groups = {AddGroup.class,UpdateGroup.class})
    private String trainingType;

    /** 培训频次 */
    @ApiModelProperty(value = "培训频次")
    @TableField("pxpl_")
    private String pxpl;

    /** 培训项目名称 */
    @ApiModelProperty(value = "培训项目名称")
    @TableField("name_")
    @NotBlank(message = "培训项目名称",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 培训对象 */
    @ApiModelProperty(value = "培训对象")
    @TableField("pxdx_")
    private String pxdx;

    /** 培训目标 */
    @ApiModelProperty(value = "培训目标")
    @TableField("goal_")
    private String goal;

    /** 主要培训内容 */
    @ApiModelProperty(value = "主要培训内容")
    @TableField("content_")
    private String content;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

}
