package com.artfess.manage.safty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.manage.safty.dao.CmgtSaftyDangerUnitDao;
import com.artfess.manage.safty.manager.CmgtSaftyDangerUnitManager;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

/**
 * 安全隐患排查对象(CmgtSaftyDangerUnit)表服务实现类
 *
 * @author 黎沐华
 * @since 2023-05-05 15:07:34
 */
@Service("cmgtSaftyDangerUnitService")
public class CmgtSaftyDangerUnitManagerImpl extends BaseManagerImpl<CmgtSaftyDangerUnitDao, CmgtSaftyDangerUnit> implements CmgtSaftyDangerUnitManager {

    @Resource
    private SysDictionaryManager sdm;

    @Override
    public PageList<CmgtSaftyDangerUnit> query(QueryFilter<CmgtSaftyDangerUnit> queryFilter) {
        return super.query(queryFilter);
    }

    @Override
    public boolean save(CmgtSaftyDangerUnit entity) {
        if (entity.getSn() == null) {
            entity.setSn(count() + 1);
        }
        return super.save(entity);
    }

    @Override
    public boolean updateById(CmgtSaftyDangerUnit entity) {
        return super.updateById(entity);
    }

    @Override
    public void removeByIds(String... ids) {
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public boolean importExcelData(MultipartFile excel) throws Exception {
        ExcelUtils<CmgtSaftyDangerUnit> excelUtil = new ExcelUtils<>(CmgtSaftyDangerUnit.class);
        List<CmgtSaftyDangerUnit> list = excelUtil.importExcel(null, excel.getInputStream());
        list.stream().filter(unit -> unit.getUnitName() != null && !unit.getUnitName().isEmpty());

        List<DictModel> zhgl_dwlx = sdm.queryDictListItemsByCode("zhgl-dwlx");
        List<DictModel> jxcspq = sdm.queryDictListItemsByCode("jxcspq");
        List<DictModel> jxcslx = sdm.queryDictListItemsByCode("jxcslx");
        List<DictModel> fxjb = sdm.queryDictListItemsByCode("fxjb");
        List<DictModel> zddwjb = sdm.queryDictListItemsByCode("zddwjb");

        list.forEach(l -> {
                    l.setType(BizUtils.getDicCodeByValue(zhgl_dwlx, l.getType()));
                    l.setSmallPlaceArea(BizUtils.getDicCodeByValue(jxcspq, l.getSmallPlaceArea()));
                    l.setSmallPlaceType(BizUtils.getDicCodeByValue(jxcslx, l.getSmallPlaceType()));
                    l.setRiskLevel(BizUtils.getDicCodeByValue(fxjb, l.getRiskLevel()));
                    l.setEmphasisLevel(BizUtils.getDicCodeByValue(zddwjb, l.getEmphasisLevel()));
                    if (StringUtil.isNotEmpty(l.getFuelType())) {
                        l.setFuelType(l.getType().replace("、", ","));
                    }
                    if (null== l.getName()){
                        l.setName("");
                    }
                    if (null== l.getPhone()){
                        l.setPhone("");
                    }
                });
        return saveBatch(list);
    }
}

