package com.artfess.manage.job;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.job.api.IJobLogService;
import com.artfess.job.model.BaseJob;
import com.artfess.job.model.SysJobLog;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.rocketmq.producer.RocketMQProducer;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

@Slf4j
@Service
public class CmgtDataCenterPushSyncJob extends BaseJob {

    @Resource
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrangeManager;

    @Resource
    private CmgtDutyVehicleGpsinfoManager cmgtDutyVehicleGpsinfoManager;

    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;

    @Resource
    private RocketMQProducer rocketMQProducer;

    protected Logger logger = LoggerFactory.getLogger(CmgtDataCenterPushSyncJob.class);

    @Resource
    private DwdSjWeatherForcastMiManager dwdSjWeatherForcastMiManager;

    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;

    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;

    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;

    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;


    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;

    private void addOperLog(String jobName, String trigName, LocalDateTime startTime,
                        LocalDateTime endTime, long runTime,String content,Integer state)   {
        IJobLogService logService= AppUtil.getBean(IJobLogService.class);
        SysJobLog jobLog=new SysJobLog(jobName, trigName, startTime, endTime, content, state,runTime);
        String id= UniqueIdUtil.getSuid();
        jobLog.setId(id);
        logService.createLog(jobLog);
    }


    public void executeJob(JobExecutionContext context) {



        //记录日志
        long startTime=System.currentTimeMillis();
        LocalDateTime strStartTime=LocalDateTime.now();


        findCurrentDutyStaff();

        long runTime=(System.currentTimeMillis()-startTime) /1000;


        log.info(new Date() + "======end=====CmgtDataCenterPushSyncJob=====rocketMQProducer======");
    }


    public static String arrDate = null;

    public JSONArray findCurrentDutyStaff() {
        if (arrDate != null && arrDate.equals(DateUtil.today())) {
            // return null;
        }
        String arrDate = DateUtil.today();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
        JSONArray r = JSONUtil.createArray();
        cmgtDutyWorkarrangeManager.findCmgtDutyWorkarrangeDtosBy(arrDate).forEach(t -> {
            for (CmgtDutyTeamMemberDto member : t.getTeamMembers()) {
                r.add(JSONUtil.createObj().putOpt("dutyDate", arrDate)
                        .putOpt("dutyStart", (t.getCmgtDutyWorkclass().getScheduleStart() != null ? t.getCmgtDutyWorkclass().getScheduleStart().format(dtf) : ""))
                        .putOpt("dutyEnd", (t.getCmgtDutyWorkclass().getDuringTime() != null ? t.getCmgtDutyWorkclass().getDuringTime().format(dtf) : ""))
                        .putOpt("name", member.getName())
                        .putOpt("sex", member.getSex())
                        .putOpt("post", member.getPost())
                        .putOpt("phone", member.getPhone())
                        .putOpt("org", member.getOrg().getName())
                        .putOpt("team", t.getCmgtDutyTeam().getName())
                );
            }
        });
        System.out.println("====================toStringPretty============" + r.toStringPretty());
        rocketMQProducer.send("zhyw_duty_staff_topic", r.toStringPretty());
        return r;
    }

}
