package com.artfess.manage.dwd.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * dwd_sj_station_arrived
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-27
 */
@Data
@ApiModel(value="DwdSjStationArrived对象", description="国铁重庆北站-历史到达人数")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdSjStationArrived extends ManageBaseModel<DwdSjStationArrived> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 日期 */
    @ApiModelProperty(value = "日期")
    @TableField("date_time_")
    private LocalDateTime dateTime;

    /** 出发或者到达 */
    @ApiModelProperty(value = "出发或者到达")
    @TableField("arrive_")
    private String arrive;

    /** 时间段 */
    @ApiModelProperty(value = "时间段")
    @TableField("time_distance_")
    private String timeDistance;

    /** 人数 */
    @ApiModelProperty(value = "人数")
    @TableField("people_cnt_")
    private String peopleCnt;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
