package com.artfess.manage.duty;


import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberDao;
import com.artfess.manage.duty.dao.CmgtDutyVehicleDao;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 安全工作计划信息 服务实现类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Service
public class CmgtDutySelectOptions {

    @Resource
    private CmgtDutyVehicleDao cmgtDutyVehicleDao;

    @Resource
    private CmgtDutyTeamMemberDao cmgtDutyTeamMemberDao;

    @Resource
    private OrgDao orgDao;

    /**
     * 查询车辆
     *
     * @return
     */
    public List<JSONObject> getCmgtDutyVehicles() {
        return cmgtDutyVehicleDao.selectList(null).stream().map(p -> {
            return JSONUtil.createObj().putOpt("label", p.getVehicleType() + "  - " + p.getCode()).putOpt("value", p.getId());
        }).collect(Collectors.toList());
    }


    public List<JSONObject> getCmgtDutyTeamMemeber() {
        return this.getCmgtDutyTeamMemeber(null);
    }

    /**
     * @return
     */
    public List<JSONObject> getCmgtDutyTeamMemeber(String query) {
        QueryWrapper<CmgtDutyTeamMember> queryWrapper = null;
        if (query != null) {
            queryWrapper = new QueryWrapper();
            queryWrapper.like("NAME_", query);
            queryWrapper.or().like("CODE_", query);
        }
        return cmgtDutyTeamMemberDao.selectList(queryWrapper).stream().map(p -> {
            return JSONUtil.createObj().putOpt("label", p.getName() + "【 " + p.getCode() + "】").putOpt("value", p.getId());

        }).collect(Collectors.toList());
    }


    public List<JSONObject> getCmgtDutyTeamMemeberByJob() {
        return getCmgtDutyTeamMemeberByJob(null);
    }

    /**
     * @return
     */
    public List<JSONObject> getCmgtDutyTeamMemeberByJob(String query) {
        QueryWrapper<CmgtDutyTeamMember> queryWrapper = null;
        if (query != null) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq("JOB_", query);
        }
        return cmgtDutyTeamMemberDao.selectList(queryWrapper).stream().map(p -> {
            Org o = orgDao.selectById(p.getOrgId());
            return JSONUtil.createObj()
                    .putOpt("label", p.getName())
                    .putOpt("value", p.getId())
                    .putOpt("org", (o != null ? o.getName() : ""));

        }).collect(Collectors.toList());
    }


}
