package com.artfess.manage.duty.manager;


import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.manager.dto.CmgtDutyWorkarrangeDto;
import com.artfess.manage.duty.model.CmgtDutyWorkarrange;
import com.artfess.manage.duty.vo.WorkArrangeInfoVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

/**
 * 排班信息 服务类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-28
 */
public interface CmgtDutyWorkarrangeManager extends BaseManager<CmgtDutyWorkarrange> {

    /**
     * 条件分页查询
     *
     * @param queryFilter
     * @return
     */
    PageList<CmgtDutyWorkarrange> pageQuery(QueryFilter<CmgtDutyWorkarrange> queryFilter);

    /**
     * 查询当月排班信息
     *
     * @param date
     * @return
     */
    List<WorkArrangeInfoVo> findAllByMonth(String date, String orgId);

    /**
     * @param date
     * @param teamMemberId
     * @return
     */
    public List<CmgtDutyWorkarrangeDto> findTeamMemberArrangeing(String date, String teamMemberId);

    /**
     * @param startDate
     * @param endDate
     * @param teamMemberId
     * @return
     */
    public List<CmgtDutyWorkarrangeDto> findTeamMemberArrangeing(String startDate, String endDate, String teamMemberId);


    void saveInfo(CmgtDutyWorkarrangeDto t, boolean isAdd);

    /**
     * 新增
     *
     * @param t
     * @return
     */
    boolean createInfo(CmgtDutyWorkarrange t);

    /**
     * 更新
     *
     * @param t
     * @return
     */
    String updateInfo(CmgtDutyWorkarrange t);

    /**
     * 删除
     *
     * @param t
     */
    void deleteInfo(CmgtDutyWorkarrange t);

    /**
     * 一键排班
     *
     * @param params
     * @return
     * @throws ParseException
     */
    boolean fastWorkarrange(Map<String, Object> params) throws ParseException;

    /**
     * 按照小组导出排班信息
     *
     * @param request
     */
    void exportExcel(HttpServletRequest request, HttpServletResponse response, String date);

    /**
     * 按照人员导出排班信息
     *
     * @param request
     * @param response
     * @param date
     */
    void exportMemberArrangeExcel(HttpServletRequest request, HttpServletResponse response, String date) throws ParseException;

    /**
     * @param arrangeDate
     * @return
     */
    public List<CmgtDutyWorkarrangeDto> findCmgtDutyWorkarrangeDtosBy(String arrangeDate);

    /**
     * @param arrangeDate
     * @param dutyTime
     * @return
     */
    public List<CmgtDutyWorkarrangeDto> findCmgtDutyWorkarrangeDtosBy(String arrangeDate, LocalTime dutyTime);

    /**
     * @return
     */
    public JSONArray findCurrentStaffOnDuty(List<String> dutyJobIds);

    /**
     * 查询历史位置与轨迹
     *
     * @param dutyJobIds
     * @param rqs
     * @return
     */
    public JSONArray findHistoryDutyStaff(List<String> dutyJobIds, List<LocalDateTime> rqs, JSONObject params);

    /**
     * 创建模拟数据
     */
    public void createSumilatedTeamMemberLoationData();
}
