package com.artfess.manage.duty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.manager.dto.CmgtDutyJobDto;
import com.artfess.manage.duty.model.CmgtDutyJob;

import java.util.List;

/**
 * 勤务岗位信息 服务类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-09
 */
public interface CmgtDutyJobManager extends BaseManager<CmgtDutyJob> {

    /**
     * 条件分页查询
     *
     * @param queryFilter
     * @return
     */
    PageList<CmgtDutyJobDto> pageQuery(QueryFilter<CmgtDutyJob> queryFilter);

    /**
     * 新增
     *
     * @param t
     * @return
     */
    String createInfo(CmgtDutyJob t);

    /**
     * 更新
     *
     * @param t
     * @return
     */
    String updateInfo(CmgtDutyJob t);

    /**
     * 删除
     *
     * @param t
     */
    void deleteInfo(CmgtDutyJob t);


    String create(CmgtDutyJobDto dto);

    String update(CmgtDutyJobDto dto);

    boolean delete(List<String> ids);

    /**
     * @return
     */
    public List<CmgtDutyJob> getJobs();

}
