/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutManager;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manager/material/out/warehouse/"})
@ApiGroup(group={"manager_biz"})
public class CmgtMaterialWarehouseOutController
extends BaseController<CmgtMaterialWarehouseInoutManager, CmgtMaterialWarehouseInout> {
    private static final Logger log = LoggerFactory.getLogger(CmgtMaterialWarehouseOutController.class);
    @Autowired
    private CmgtMaterialWarehouseInoutDetailManager warehouseInoutDetailManager;
    @Autowired
    private CmgtMaterialWarehouseInoutManager warehouseInoutManager;
    @Autowired
    private CmgtMaterialQuantityManage quantityManage;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtMaterialWarehouseInout t) {
        for (CmgtMaterialWarehouseInoutDetail d : t.getDetailList()) {
            if (d.getDescription() == null) continue;
            int flag = ((CmgtMaterialQuantity)((Object)this.quantityManage.getById((Serializable)((Object)d.getDescription())))).getQuantity().compareTo(d.getQuantity());
            System.out.println("----------------flag----------" + flag);
            if (flag >= 0) continue;
            return new CommonResult("-011", d.getName() + "\u5e93\u5b58\u4e0d\u8db3");
        }
        t.setDataType("1");
        boolean result = this.warehouseInoutManager.createInout(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getDetailList"})
    @ApiOperation(value="\u83b7\u53d6\u51fa\u5e93\u5355\u4e0b\u6240\u6709\u7269\u8d44\u660e\u7ec6")
    public CommonResult<String> getDetailList(@RequestBody String oid) {
        List<CmgtMaterialWarehouseInoutDetail> list = this.warehouseInoutDetailManager.findMaterialDetailById(oid);
        return CommonResult.success(list, null);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtMaterialWarehouseInout t) {
        for (CmgtMaterialWarehouseInoutDetail d : t.getDetailList()) {
            if (d.getMaterialInfoId() == null) continue;
            BigDecimal flag = this.warehouseInoutManager.getQuantity(t.getId(), d.getQuantityId(), d.getQuantity());
            System.out.println("----------------flag----------" + flag);
            if (flag == null || flag.compareTo(new BigDecimal(0)) >= 0) continue;
            return new CommonResult("-011", d.getName() + "\u5e93\u5b58\u4e0d\u8db3");
        }
        boolean result = this.warehouseInoutManager.updateInout(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = this.warehouseInoutManager.removeInoutById(ids);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

