/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.job;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.job.api.IJobLogService;
import com.artfess.job.model.BaseJob;
import com.artfess.job.model.SysJobLog;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.rocketmq.producer.RocketMQProducer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CmgtDataCenterPushSyncJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(CmgtDataCenterPushSyncJob.class);
    @Resource
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrangeManager;
    @Resource
    private CmgtDutyVehicleGpsinfoManager cmgtDutyVehicleGpsinfoManager;
    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;
    @Resource
    private RocketMQProducer rocketMQProducer;
    protected Logger logger = LoggerFactory.getLogger(CmgtDataCenterPushSyncJob.class);
    @Resource
    private DwdSjWeatherForcastMiManager dwdSjWeatherForcastMiManager;
    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;
    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;
    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;
    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;
    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;
    public static String arrDate = null;

    private void addOperLog(String jobName, String trigName, LocalDateTime startTime, LocalDateTime endTime, long runTime, String content, Integer state) {
        IJobLogService logService = (IJobLogService)AppUtil.getBean(IJobLogService.class);
        SysJobLog jobLog = new SysJobLog(jobName, trigName, startTime, endTime, content, state, Long.valueOf(runTime));
        String id = UniqueIdUtil.getSuid();
        jobLog.setId(id);
        logService.createLog(jobLog);
    }

    public void executeJob(JobExecutionContext context) {
        long startTime = System.currentTimeMillis();
        LocalDateTime strStartTime = LocalDateTime.now();
        this.findCurrentDutyStaff();
        long runTime = (System.currentTimeMillis() - startTime) / 1000L;
        log.info(new Date() + "======end=====CmgtDataCenterPushSyncJob=====rocketMQProducer======");
    }

    public JSONArray findCurrentDutyStaff() {
        if (arrDate == null || arrDate.equals(DateUtil.today())) {
            // empty if block
        }
        String arrDate = DateUtil.today();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
        JSONArray r = JSONUtil.createArray();
        this.cmgtDutyWorkarrangeManager.findCmgtDutyWorkarrangeDtosBy(arrDate).forEach(t -> {
            for (CmgtDutyTeamMemberDto member : t.getTeamMembers()) {
                r.add((Object)JSONUtil.createObj().putOpt("dutyDate", (Object)arrDate).putOpt("dutyStart", (Object)(t.getCmgtDutyWorkclass().getScheduleStart() != null ? t.getCmgtDutyWorkclass().getScheduleStart().format(dtf) : "")).putOpt("dutyEnd", (Object)(t.getCmgtDutyWorkclass().getDuringTime() != null ? t.getCmgtDutyWorkclass().getDuringTime().format(dtf) : "")).putOpt("name", (Object)member.getName()).putOpt("sex", (Object)member.getSex()).putOpt("post", (Object)member.getPost()).putOpt("phone", (Object)member.getPhone()).putOpt("org", (Object)member.getOrg().getName()).putOpt("team", (Object)t.getCmgtDutyTeam().getName()));
            }
        });
        System.out.println("====================toStringPretty============" + r.toStringPretty());
        this.rocketMQProducer.send("zhyw_duty_staff_topic", r.toStringPretty());
        return r;
    }
}

