package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 视频点位信息表（DEVICE_VIDEO_POINT）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
@Data
@ApiModel(value="DeviceVideoPoint对象", description="视频点位信息表（DEVICE_VIDEO_POINT）")
public class DeviceVideoPoint extends AutoFillModel<DeviceVideoPoint> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "所属目录_CODE")
    @TableField("catalog_code_")
    private String catalogCode;

    @ApiModelProperty(value = "所属区域_CODE")
    @TableField("zone_code_")
    private String zoneCode;

    @ApiModelProperty(value = "视频点编号（或视频平台点位编号）")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "视频点名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "所属平台(HK：海康平台，ZG：紫光平台)")
    @TableField("platform_")
    private String platform;

    @ApiModelProperty(value = "通道号")
    @TableField("aisle_")
    private String aisle;

    @ApiModelProperty(value = "设备IP")
    @TableField("ip_")
    private String ip;

    @ApiModelProperty(value = "经度")
    @TableField("lgtd_")
    private String lgtd;

    @ApiModelProperty(value = "纬度(前端需要调整字段)")
    @TableField("lttd_")
    private String lttd;

    @ApiModelProperty(value = "安装详细地址(前端需要调整字段)")
    @TableField("address_")
    private String address;

    @ApiModelProperty(value = "设备状态【字典】（0：不在线，1：在线）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "点位扩展信息")
    @TableField(exist = false)
    private DeviceVideoPointExtend deviceVideoPointExtend;
}
