package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 对合同信息进行管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Data
@FieldRepeat(fields = {"contractCode","contractName"},message = "合同名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceBaseContract对象", description="对合同信息进行管理")
public class DeviceBaseContract extends BaseModel<DeviceBaseContract> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定合同id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入合同编码",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "合同唯一编码")
    @TableField("CONTRACT_CODE_")
    private String contractCode;

    @NotBlank(message = "请输入合同名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @NotBlank(message = "请选择合同类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "合同类型（1：采购合同，2：建设合同，3：运维合同）")
    @TableField("CONTRACT_TYPE_")
    private String contractType;

    @ApiModelProperty(value = "签订日期")
    @TableField("SIGN_DATE_")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始时间")
    @TableField("START_DATE_")
    private LocalDate startDate;

    @ApiModelProperty(value = "结束时间")
    @TableField("END_DATE_")
    private LocalDate endDate;

    @ApiModelProperty(value = "责任人")
    @TableField("PERSON_LIABLE_")
    private String personLiable;

    @ApiModelProperty(value = "合同状态(1：进行中，2：已完成)")
    @TableField("CONTRACT_STATUS_")
    private String contractStatus;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

      @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "供应商合同关联")
    @TableField(exist = false)
    private DeviceRelationSupplierContract relationSupplierContract;

    @ApiModelProperty(value = "供应商名称")
    @TableField(exist = false)
    private String companyName;

    @ApiModelProperty(value = "扩展信息填充内容")
    @TableField(exist = false)
    private List<DeviceBaseParamsValue> paramsValueList;

}
