package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceMetadataFunctionsDao;
import com.artfess.device.base.dao.DeviceMetadataFunctionsParamsDao;
import com.artfess.device.base.manager.DeviceMetadataFunctionsManager;
import com.artfess.device.base.model.DeviceMetadataFunctions;
import com.artfess.device.base.model.DeviceMetadataFunctionsParams;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 产品物模型功能 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceMetadataFunctionsManagerImpl extends BaseManagerImpl<DeviceMetadataFunctionsDao, DeviceMetadataFunctions> implements DeviceMetadataFunctionsManager {

    @Resource
    private DeviceMetadataFunctionsParamsDao metadataFunctionsParamsDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String createInfo(DeviceMetadataFunctions t) {
        this.vaild(t);
        int insert = this.baseMapper.insert(t);
        if(insert > 0) {
            processParams(t.getParams(), t.getId());
            return t.getId();
        }

        return null;
    }

    private void processParams(List<DeviceMetadataFunctionsParams> params, String functionId) {
        QueryWrapper<DeviceMetadataFunctionsParams> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("function_id_", functionId);
        this.metadataFunctionsParamsDao.delete(queryWrapper);

        params.forEach(functionsParams -> {
            functionsParams.setFunctionId(functionId);
            this.metadataFunctionsParamsDao.insert(functionsParams);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String updateInfo(DeviceMetadataFunctions t) {
        this.vaild(t);
        int insert = this.baseMapper.updateById(t);
        if(insert > 0) {
            processParams(t.getParams(), t.getId());
            return t.getId();
        }
        return null;
    }

    @Override
    public DeviceMetadataFunctions findById(String id) {
        DeviceMetadataFunctions deviceMetadataFunctions = this.baseMapper.selectById(id);
        if(null == deviceMetadataFunctions) {
            return null;
        }
        QueryWrapper<DeviceMetadataFunctionsParams> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("function_id_", id);
        List<DeviceMetadataFunctionsParams> deviceMetadataFunctionsParams = metadataFunctionsParamsDao.selectList(queryWrapper);
        deviceMetadataFunctions.setParams(deviceMetadataFunctionsParams);
        return deviceMetadataFunctions;
    }

    public void vaild(DeviceMetadataFunctions t) {
        QueryWrapper<DeviceMetadataFunctions> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("code_", t.getCode()).eq("product_id_",t.getProductId());
        List<DeviceMetadataFunctions> functions = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(functions)) {
            throw new IllegalArgumentException("功能标识已重复，请重新输入");
        }
        queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("name_", t.getName()).eq("product_id_",t.getProductId());

        functions = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(functions)) {
            throw new IllegalArgumentException("功能名称已重复，请重新输入");
        }
    }
}
