package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceBaseWarehouseDao;
import com.artfess.device.base.manager.DeviceBaseWarehouseManager;
import com.artfess.device.base.model.DeviceBaseWarehouse;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 对备品库信息进行管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Service
public class DeviceBaseWarehouseManagerImpl extends BaseManagerImpl<DeviceBaseWarehouseDao, DeviceBaseWarehouse> implements DeviceBaseWarehouseManager {

    @Override
    public List<DeviceBaseWarehouse> findAll(DeviceBaseWarehouse wareHouse) {
        QueryWrapper<DeviceBaseWarehouse> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(wareHouse.getWarehouseCode())){
            queryWrapper.like("WAREHOUSE_CODE_", wareHouse.getWarehouseCode());
        }

        if(StringUtils.isNotBlank(wareHouse.getWarehouseName())){
            queryWrapper.like("WAREHOUSE_NAME_", wareHouse.getWarehouseName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }
}
