package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.model.DeviceBaseContract;

/**
 * 对合同信息进行管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
public interface DeviceBaseContractManager extends BaseManager<DeviceBaseContract> {

    boolean saveContract(DeviceBaseContract t);

    /**
     * 根据id获取合同信息
     * @param id
     * @return
     */
    DeviceBaseContract findById(String id);

    /**
     * 修改合同信息
     * @param t
     * @return
     */
    boolean updateContract(DeviceBaseContract t);

    /**
     * 合同分页查询
     * @param queryFilter
     * @return
     */
    PageList<DeviceBaseContract> findByPage(QueryFilter<DeviceBaseContract> queryFilter);
}
