package com.artfess.device.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.manager.DeviceStatusLogManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.vo.StatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author 黎沐华
 * @date 2022/8/19 15:59
 */
@Slf4j
@RestController
@Api(tags = "设施设备-性能分析")
@RequestMapping("/performanceAnalysis/v1/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceSafetyController {

    @Autowired
    private DeviceStatusLogManager logManager;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;

    @PostMapping("/statistics")
    @ApiOperation("设备状态统计")
    public CommonResult<List<StatisticsVo>> statistics(@ApiParam(name="dto", value="参数") @RequestBody StatisticsDto dto) {
        log.info("设备日志状态统计请求参数:{}", dto);
        List<StatisticsVo> data = logManager.statistics(dto);
        log.info("设备日志状态统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/statisticsSub")
    @ApiOperation("设备状态统计·下钻")
    public CommonResult<List<StatisticsVo>> statisticsSub(@ApiParam(name="dto", value="参数") @RequestBody StatisticsDto dto) {
        log.info("设备日志状态统计·下钻请求参数:{}", dto);
        List<StatisticsVo> data = logManager.statisticsSub(dto);
        log.info("设备日志状态统计·下钻响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/statisticsTrouble")
    @ApiOperation("设备故障次数统计")
    public CommonResult<List<StatisticsVo>> statisticsTrouble(@ApiParam(name="dto", value="参数") @RequestBody StatisticsDto dto) {
        log.info("设备日志状态统计请求参数:{}", dto);
        List<StatisticsVo> data = logManager.statisticsTrouble(dto);
        log.info("设备日志状态统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/statisticsCurrentTrouble")
    @ApiOperation(value = "当前设备故障次数统计",notes = "截止至当前时间的次数统计")
    public CommonResult<List<StatisticsVo>> statisticsCurrentTrouble() {
        log.info("当前设备故障次数统计请请求开始......");
        List<StatisticsVo> data = logManager.statisticsCurrentTrouble();
        log.info("当前设备故障次数统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/troubleCountMonthly")
    @ApiOperation(value = "各月份设备故障次数统计",notes = "从当前月开始前十二个月的数据")
    public CommonResult<List<StatisticsVo>> troubleCountMonthly() {
        log.info("各月份设备故障次数统计请求开始......");
        List<StatisticsVo> data = logManager.troubleCountMonthly();
        log.info("各月份设备故障次数统计响应结果:{}", data);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/statisticsWarn")
    @ApiOperation("设备告警统计")
    public CommonResult<List<StatisticsVo>> statisticsWarn(@ApiParam(name="dto", value="参数") @RequestBody StatisticsDto dto) {
        log.info("设备告警统计请求参数:{}", dto);
        List<StatisticsVo> data = warnInfoManager.statisticsWarn(dto);
        log.info("设备告警统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/statisticsWarnSub")
    @ApiOperation("设备告警统计·下钻")
    public CommonResult<List<StatisticsVo>> statisticsWarnSub(@ApiParam(name="dto", value="参数") @RequestBody StatisticsDto dto) {
        log.info("设备告警统计·下钻请求参数:{}", dto);
        List<StatisticsVo> data = warnInfoManager.statisticsWarnSub(dto);
        log.info("设备告警统计·下钻响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/warnCountMonthly")
    @ApiOperation(value = "各月份设备告警次数统计",notes = "从当前月开始前十二个月的数据")
    public CommonResult<JSONObject> warnCountMonthly() {
        log.info("各月份设备告警次数统计计请求开始......");
        List<StatisticsVo> data = warnInfoManager.warnCountMonthly();
        log.info("各月份设备故障次数统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

    @PostMapping("/warnCountCurrently")
    @ApiOperation(value = "当前设备告警次数统计",notes = "截止至当前时间的次数统计")
    public CommonResult<JSONObject> warnCountCurrently() {
        log.info("当前设备告警次数统计请求开始......");
        List<StatisticsVo> data = warnInfoManager.warnCountCurrently();
        log.info("当前设备告警次数统计响应结果:{}", data);
        return CommonResult.success(data,"查询成功");
    }

}
