package com.artfess.device.monitor.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 升降机预警信息vo
 *
 * @Author : min.wu
 * @Date: 2022/08/04 09:58
 */
@Data
public class BollardWarnVo {

    @ApiModelProperty("结果编码。0-成功，其它-失败")
    private String response_code;

    @ApiModelProperty("目标升降柱的控制器 id")
    private String controller_id;

    @ApiModelProperty("结果信息")
    private String response_msg;

    @ApiModelProperty("升降柱位置状态，00-底部，FF-顶部，55-中间(不是底部也不是顶部)")
    private String status;

    @ApiModelProperty("升降柱位置状态，00-底部，FF-顶部，55-中间(不是底部也不是顶部)。同 status")
    private String position;

    @ApiModelProperty("升降柱最近的一次动作，01-上升，10-下降。这个可以做为升降柱的逻辑位置：01-顶部，10-底部，如果升降柱不配装限位开关，升降柱的位置通过这个字段判断")
    private String last_action;

    @ApiModelProperty("报警。0001-上限位报警，0002-下限位报警，0003-补压报警，空字符串-没有报警")
    private String alert;
}
