package com.artfess.device.monitor.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 实时监控-标识牌监控（DEVICE_DATA_SIGNBOAERD）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
@Data
@TableName("device_data_signboaerd")
@ApiModel(value="DeviceDataSignboaerd对象", description="实时监控-标识牌监控（DEVICE_DATA_SIGNBOAERD）")
public class DeviceDataSignboaerd extends BaseModel<DeviceDataSignboaerd> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据采集时间")
    @TableField("COLL_TIME_")
    private LocalDateTime collTime;

    @ApiModelProperty(value = "设备唯一标识")
    @TableField("DEVICE_CODE_")
    private String deviceCode;

    @ApiModelProperty(value = "原始采集数据")
    @TableField("SRC_DATA_")
    private String srcData;

    @ApiModelProperty(value = "数据类型【字典】（0--震动报警 ，1--震动报警解除，10-正常数据）")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "X 轴角度 (单位：°度)")
    @TableField("ANGLE_X_")
    private BigDecimal angleX;

    @ApiModelProperty(value = "Y 轴角度 (单位：°度)")
    @TableField("ANGLE_Y_")
    private BigDecimal angleY;

    @ApiModelProperty(value = "Z 轴角度 (单位：°度)")
    @TableField("ANGLE_Z_")
    private BigDecimal angleZ;

    @ApiModelProperty(value = "电池电量（单位：%）")
    @TableField("BATTERY_VALUE_")
    private BigDecimal batteryValue;

    @ApiModelProperty(value = "设备电压（单位：V）")
    @TableField("BATTERY_VOLTAGE_")
    private BigDecimal batteryVoltage;

    @ApiModelProperty(value = "报警ID")
    @TableField("WARN_ID_")
    private String warnId;

    @ApiModelProperty(value = "入库时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "设备名称")
    @TableField(exist = false)
    private String deviceName;
}
