package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 设备告警配置
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@TableName("DEVICE_WARN_CONF")
@ApiModel(value="DeviceWarnConf对象", description="设备告警配置")
public class DeviceWarnConf extends AutoFillModel<DeviceWarnConf> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    //@NotBlank(message = "请输入产品告警配置ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "产品告警配置ID")
    @TableField("product_conf_id_")
    private String productConfId;

    @NotBlank(message = "请输入设备ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备ID")
    @TableField("device_id_")
    private String deviceId;

    @NotBlank(message = "请输入告警名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警名称")
    @TableField("warn_name_")
    private String warnName;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "状态 （1：启用，0：禁用）")
    @TableField("status_")
    private Integer status;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "配置详情")
    @TableField(exist = false)
    private List<DeviceWarnConfDetails> details;
}
