package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 设备状态日志
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@TableName("DEVICE_STATUS_LOG")
@ApiModel(value="DeviceStatusLog对象", description="设备状态日志")
public class DeviceStatusLog extends AutoFillModel<DeviceStatusLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "设备标识deviceCode不能为空",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "设备标识")
    @TableField("device_code_")
    private String deviceCode;

    @NotBlank(message = "设备状态deviceStatus不能为空",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "设备状态【字典】（-1：报废，1：正常、2：故障、3、报警、9：其他）")
    @TableField("device_status_")
    private String deviceStatus;

    @NotBlank(message = "设备类型deviceType不能为空",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备类型【字典】（1：标识牌，2：低洼积水，3：危险源，4：路障，5：摄像头，6：蓝牙信标，7：信息发布屏")
    @TableField("device_type_")
    private String deviceType;

    @ApiModelProperty(value = "状态开始时间")
    @TableField("start_time_")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "状态结束时间")
    @TableField("end_time_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "状态时长 (分钟)")
    @TableField("time_length_")
    private Long timeLength;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "设备名称")
    @TableField(exist = false)
    private String deviceName;
}
