package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 设备信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@TableName("DEVICE_INFO")
@ApiModel(value="DeviceInfo对象", description="设备信息")
@FieldRepeat(fields = {"code","name"},message = "设备名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DeviceInfo extends AutoFillModel<DeviceInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择产品",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "产品_ID")
    @TableField("product_id_")
    private String productId;

    @NotBlank(message = "请输入外部设备对接编号",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "外部设备对接编号")
    @TableField("out_code_")
    private String outCode;

    @NotBlank(message = "请输入设备标识",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备标识")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请输入设备名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "名称全路径")
    @TableField("full_name_")
    private String fullName;

    @ApiModelProperty("设备权限级别 数字越大级别越高【字典】（1：1级、  2：2级、3：3级、4：4级）")
    @NotNull(message = "请选择设备操作权限",groups = {AddGroup.class,UpdateGroup.class})
    @TableField("LEVEL_")
    private Integer level;

    @ApiModelProperty(value = "设备状态【字典】（-1：报废，1：正常、2：故障、3、报警、9：其他）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "设备IP")
    @TableField("ip_")
    private String ip;

    @ApiModelProperty(value = "设备锁定（路障设备）【字典】（0：正常，1：锁定）")
    @TableField("IS_LOCK_")
    private String isLock;

    @ApiModelProperty(value = "锁定人员账户")
    @TableField("LOCK_USER_")
    private String lockUser;

    @ApiModelProperty(value = "所属区域（关联区域表ID）")
    @TableField("area_id_")
    private String areaId;

    @ApiModelProperty(value = "所属行政区划")
    @TableField("addvcd_")
    private String addvcd;

    @ApiModelProperty(value = "经度")
    @TableField("lgtd_")
    private String lgtd;

    @ApiModelProperty(value = "纬度")
    @TableField("lttd_")
    private String lttd;

    @ApiModelProperty(value = "安装详细地址")
    @TableField("address_")
    private String address;

    @ApiModelProperty(value = "设备供应商")
    @TableField("supplier_company_id_")
    private String supplierCompanyId;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "gis区域标识")
    @TableField("gis_area_")
    private String gisArea;

    @ApiModelProperty(value = "设备维护单位")
    @TableField("repair_company_id_")
    private String repairCompanyId;

    @ApiModelProperty(value = "设备维护人员")
    @TableField("repair_user_id_")
    private String repairUserId;

    @ApiModelProperty(value = "设备管理单位")
    @TableField("manager_company_id_")
    private String managerCompanyId;

    @ApiModelProperty(value = "设备管理人员")
    @TableField("manager_user_id_")
    private String managerUserId;

    @ApiModelProperty(value = "安装地点类型【字典】（1：室外，2：室内）")
    @TableField("address_type_")
    private String addressType;

    @ApiModelProperty(value = "安装楼层【字典】（-2：负二楼，-1：负一楼，1：一楼、2：二楼、3：三楼）")
    @TableField("floor_")
    private String floor;

    @ApiModelProperty(value = "禁用标识【字典】（0：禁用，1：启用）")
    @TableField(value = "flag_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private Integer flag;

    @ApiModelProperty(value = "设备元数据")
    @TableField(value = "meta_data_")
    private String metaData;

    @ApiModelProperty(value = "关联合同信息")
    @TableField(exist = false)
    private List<DeviceRelationContract> contractList;

    @ApiModelProperty(value = "设备扩展信息值")
    @TableField(exist = false)
    private List<DeviceParamsValue> paramsValueList;

    @ApiModelProperty(value = "所属产品")
    @TableField(exist = false)
    private String productName;

    @ApiModelProperty(value = "所属供应商")
    @TableField(exist = false)
    private String companyName;

    @ApiModelProperty(value = "产品图标")
    @TableField(exist = false)
    private String icon;

    @ApiModelProperty(value = "设备管理人员")
    @TableField(exist = false)
    private String managerUserName;

    @ApiModelProperty(value = "设备维护人员")
    @TableField(exist = false)
    private String repairUserName;

    @ApiModelProperty(value = "所属区域")
    @TableField(exist = false)
    private String areaName;

    @ApiModelProperty(value = "所属区域编码")
    @TableField(exist = false)
    private String areaCode;

    @ApiModelProperty(value = "所属行政区划")
    @TableField(exist = false)
    private String addressName;

    @ApiModelProperty(value = "产品类型")
    @TableField(exist = false)
    private String productType;
}
